/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.joauth;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class UrlCodec {
    private static final String UTF_8 = "UTF-8";
    private static final Charset UTF_8_CHARSET = Charset.forName("UTF-8");
    private static final String PLUS = "+";
    private static final String ENCODED_PLUS = "%20";
    private static final String UNDERSCORE = "_";
    private static final String ENCODED_UNDERSCORE = "%5F";
    private static final String DASH = "-";
    private static final String ENCODED_DASH = "%2D";
    private static final String PERIOD = ".";
    private static final String ENCODED_PERIOD = "%2E";
    private static final String TILDE = "~";
    private static final String ENCODED_TILDE = "%7E";
    private static final String COMMA = ",";
    private static final String ENCODED_COMMA = "%2C";
    private static final String ENCODED_OPEN_BRACKET = "%5B";
    private static final String ENCODED_CLOSE_BRACKET = "%5D";

    private static boolean isUnreserved(byte b) {
        return b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57 || b == 46 || b == 45 || b == 95 || b == 126;
    }

    private static boolean isUnreserved(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_' || c == '~';
    }

    public static String encode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        int startingIndex = 0;
        boolean hasReservedChars = false;
        while (startingIndex < s.length() && !hasReservedChars) {
            if (!UrlCodec.isUnreserved(s.charAt(startingIndex))) {
                hasReservedChars = true;
                continue;
            }
            ++startingIndex;
        }
        if (hasReservedChars && startingIndex < s.length()) {
            sb = new StringBuilder(s.length() + 40);
            sb.append(s.substring(0, startingIndex));
            byte[] byteArray = s.substring(startingIndex).getBytes(UTF_8_CHARSET);
            for (int i = 0; i < byteArray.length; ++i) {
                byte bite = byteArray[i];
                if (UrlCodec.isUnreserved(bite)) {
                    sb.append((char)bite);
                    continue;
                }
                sb.append("%").append(Integer.toHexString(bite >> 4 & 0xF).toUpperCase()).append(Integer.toHexString(bite & 0xF).toUpperCase());
            }
        }
        return sb == null ? s : sb.toString();
    }

    public static String normalize(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = null;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '%' || c == '+' || c == ',' || c == '[' || c == ']') {
                if (sb == null) {
                    sb = new StringBuilder(s.length() + 40);
                    sb.append(s.substring(0, i));
                }
                if (c == '%') {
                    if (i + 3 <= length) {
                        String spChar = s.substring(i, i + 3).toUpperCase();
                        String toAppend = spChar.toString();
                        if (ENCODED_UNDERSCORE.equals(spChar)) {
                            toAppend = UNDERSCORE;
                        } else if (ENCODED_DASH.equals(spChar)) {
                            toAppend = DASH;
                        } else if (ENCODED_TILDE.equals(spChar)) {
                            toAppend = TILDE;
                        } else if (ENCODED_PERIOD.equals(spChar)) {
                            toAppend = PERIOD;
                        }
                        sb.append(toAppend);
                        i += 2;
                        continue;
                    }
                    sb.append(c);
                    continue;
                }
                if (c == ',') {
                    sb.append(ENCODED_COMMA);
                    continue;
                }
                if (c == '+') {
                    sb.append(ENCODED_PLUS);
                    continue;
                }
                if (c == '[') {
                    sb.append(ENCODED_OPEN_BRACKET);
                    continue;
                }
                if (c != ']') continue;
                sb.append(ENCODED_CLOSE_BRACKET);
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        return sb == null ? s : sb.toString();
    }

    public static String decode(String s) throws UnsupportedEncodingException {
        return s == null ? null : URLDecoder.decode(s, UTF_8);
    }
}

