from typing import AsyncIterator, Iterator
from dataiku.llm.python.custom.base_model import BaseModel
from dataiku.llm.python.processing import _NotImplementedError
from dataiku.llm.python.types import CompletionSettings, CompletionResponse, SingleCompletionQuery, StreamCompletionResponse
from dataiku.llm.tracing import SpanBuilder

class BaseLLM(BaseModel):
    """The base interface for a Custom LLM"""

    def process(self, query: SingleCompletionQuery, settings: CompletionSettings, trace: SpanBuilder) -> CompletionResponse:
        raise _NotImplementedError

    async def aprocess(self, query: SingleCompletionQuery, settings: CompletionSettings, trace: SpanBuilder) -> CompletionResponse:
        raise _NotImplementedError

    def process_stream(self, query: SingleCompletionQuery, settings: CompletionSettings, trace: SpanBuilder) -> Iterator[StreamCompletionResponse]:
        raise _NotImplementedError
        yield

    async def aprocess_stream(self, query: SingleCompletionQuery, settings: CompletionSettings, trace: SpanBuilder) -> AsyncIterator[StreamCompletionResponse]:
        raise _NotImplementedError
        yield
