(function() {
    "use strict";

    const features = {
        bindings: {
            features: '=',
            onFeatureChange: '<'
        },
        templateUrl: "/static/dataiku/auto-feature-generation/features/features.component.html",
        controller: function afgFeaturesController($scope, $element, $attrs, AutoFeatureGenerationRecipeService) {
            const ctrl = this;
            ctrl.$onInit = function() {
                ctrl.allFeatures = AutoFeatureGenerationRecipeService.initFeaturesState(ctrl.features);
                ctrl.VARIABLE_TYPES = AutoFeatureGenerationRecipeService.VARIABLE_TYPES;
            };

            ctrl.updateFeatureState = function() {
                const features = [];
                for (let featureType of AutoFeatureGenerationRecipeService.FEATURES_BY_CATEGORY) {
                    const featuresForCurrentCategory = ctrl.allFeatures.find(feat => feat.categoryName === featureType.categoryName);
                    for (let feature of featuresForCurrentCategory["features"]) {
                        if (feature.selected) {
                            features.push(feature.name);
                        }
                    }
                }
                ctrl.features = features;
                ctrl.onFeatureChange();
            };
        }
    };
    angular.module('dataiku.autoFeatureGeneration').component("features", features);
})();


