(function() {
    'use strict';

    /**
     * <display-label-subform
     *      measure="measure"
     *      // OR
     *      dimension="dimension"
     *      chart-type="{{chart.def.type}}"
     * </display-label-subform>
     *
     * @param { com.dataiku.dip.pivot.frontend.model.MeasureDef | undefined }       measure
     * @param { com.dataiku.dip.pivot.frontend.model.DimensionDef | undefined }     dimension
     * @param { com.dataiku.dip.pivot.frontend.model.chartType | undefined }        chartType
     */
    angular.module('dataiku.charts').component('displayLabelSubform', {
        templateUrl: '/static/dataiku/js/simple_report/components/display-label-subform/display-label-subform.component.html',
        bindings: {
            measure: '<',
            dimension: '<',
            chartType: '@',
            helperText: '<'
        },
        controller: function(ChartLabels, $scope, translate) {
            const ctrl = this;
            $scope.translate = translate;
            ctrl.placeholder = '';
            ctrl.measureOrNumericalDimension = null;

            ctrl.$onChanges = function() {
                ctrl.measureOrNumericalDimension = ctrl.measure || ctrl.dimension;
                ctrl.type = ctrl.measure ? 'measure' : 'dimension';
                ctrl.updatePlaceholder(ctrl.measureOrNumericalDimension, ctrl.type);
            };

            /**
             * Updates the placeholder value based on the given measure or dimension.
             *
             * @param {com.dataiku.dip.pivot.frontend.model.MeasureDef | com.dataiku.dip.pivot.frontend.model.DimensionDef}    measureOrNumericalDimension    the measure or dimension from which to compute the placeholder
             * @param {'measure' | 'dimension'}                                                                                type                           the type of the first parameter
             */
            ctrl.updatePlaceholder = function(measureOrNumericalDimension, type) {
                if (!measureOrNumericalDimension) {
                    ctrl.placeholder = '';
                    return;
                }
                let getPlaceholder;
                if (measureOrNumericalDimension.isA === 'ua') {
                    getPlaceholder = ChartLabels.getUaLabel;
                } else {
                    getPlaceholder = type === 'measure' ? ChartLabels.getLongMeasureLabel : ChartLabels.getDimensionLabel;
                }

                ctrl.placeholder = getPlaceholder(measureOrNumericalDimension);
            };
        }
    });
})();
