(function() {
    'use strict';
    const app = angular.module('dataiku.charts');

    /**
     * (!) This directive previously was in static/dataiku/js/simple_report/chart_dragdrop.js
     */
    app.directive('chartDragDropList', function($parse, Assert) {
        return {
            scope: true,
            controller: 'ChartDragDropController',
            link: function($scope, element, attrs) {

                let acceptFunc = function(data) {
                    return {
                        accept: true,
                        message: 'Drop here'
                    };
                };
                if (attrs.acceptDrop) {
                    const parsed = $parse(attrs.acceptDrop);
                    acceptFunc = function(data) {
                        return parsed($scope.$parent || $scope, { 'data': data });
                    };
                }
                const placeholderPos = attrs.placeholderPos || 'end';
                const direction = attrs.direction || 'horizontal';

                const placeholder = $('<li class="sortable-placeholder" />');
                let placeholderAttachedOnce = false;

                const onDragOverOrEnter = function(e) {
                    this.classList.add('over');
                    $scope.addClassHereAndThere(this, 'over');

                    const dropLi = $(e.target).closest('li');

                    if ($scope.activeDragDrop.draggedElementToHide) {
                        $scope.activeDragDrop.draggedElementToHide.hide();
                    }

                    // Do we accept this payload ?
                    const accepted = acceptFunc($scope.activeDragDrop.data);
                    if (accepted.accept) {
                        e.dataTransfer.dropEffect = 'copyMove';

                        if (dropLi.length !== 0) {

                            // Determine the insertion point for the placeholder based on the list direction.
                            if (direction === 'horizontal') {
                                const mouseX = e.clientX;
                                const dropLiWidth = dropLi.outerWidth();
                                const dropLiLeft = dropLi.offset().left;
                                const isLeft = mouseX < dropLiLeft + dropLiWidth / 2;
                                if (isLeft) {
                                    dropLi.before(placeholder);
                                } else {
                                    dropLi.after(placeholder);
                                }
                            } else {
                                const mouseY = e.clientY;
                                const dropLiTop = dropLi.offset().top;
                                const dropLiHeight = dropLi.outerHeight();
                                const isTop = mouseY < dropLiTop + dropLiHeight / 2;
                                if (isTop) {
                                    dropLi.before(placeholder);
                                } else {
                                    dropLi.after(placeholder);
                                }
                            }
                        }
                        e.preventDefault();
                    } else {
                        $scope.$apply(function() {
                            $scope.validity.tempError = {};
                            $scope.validity.tempError.type = 'MEASURE_REJECTED';
                            $scope.validity.tempError.message = accepted.message;
                        });
                    }
                };
                element[0].addEventListener('dragover', onDragOverOrEnter, false);
                element[0].addEventListener('dragenter', onDragOverOrEnter, false);

                element[0].addEventListener('dragleave', function(e) {
                    $scope.removeClassHereAndThere(this, 'over');
                    $scope.$apply(function() {
                        if ($scope.validity && $scope.validity.tempError) {
                            delete $scope.validity.tempError;
                        }
                    });
                    return false;
                }, false);

                /*
                 * This is triggered as soon as a drag becomes active on the page
                 * and highlights the drop zone if it's accepted
                 */
                $scope.$watch('activeDragDrop.active', function(nv, ov) {
                    if (nv) {
                        const accepted = acceptFunc($scope.activeDragDrop.data);
                        if (accepted.accept) {
                            $scope.addClassHereAndThere(element, 'drop-accepted');
                            window.setTimeout(function() {
                                // With the new component pivot-filter-list.component.js the directive is no longer directly set on the ul element but on the component itself.
                                const listElement = element[0].tagName === 'UL' ? element : element.find('ul').first();
                                if (placeholderPos == 'end') {
                                    listElement.append(placeholder);
                                } else {
                                    listElement.prepend(placeholder);
                                }
                                placeholderAttachedOnce = true;
                            }, 10);
                        } else {
                            $scope.addClassHereAndThere(element, 'drop-rejected');
                        }
                    } else {
                        $scope.removeClassHereAndThere(element, 'drop-accepted');
                        $scope.removeClassHereAndThere(element, 'drop-rejected');

                        if (placeholderAttachedOnce) {
                            window.setTimeout(function() {
                                placeholder.detach();
                            }, 10);
                        }
                    }
                }, true);

                element[0].addEventListener('drop', function(e) {
                    Assert.trueish($scope.activeDragDrop.active, 'no active drag and drop');

                    // Stops some browsers from redirecting.
                    if (e.stopPropagation) {
                        e.stopPropagation();
                    }

                    $scope.removeClassHereAndThere(this, 'over');

                    // At which index are we dropping ?
                    let dropIndex = $(e.target).index();

                    // If dropping on the ul element, try dropping it on the displayed placeholder, if not found drop it at the end of the list
                    if ($(e.target).is('ul')) {
                        dropIndex = Array.from(e.target.children).findIndex(item => item === placeholder[0]);
                        if (dropIndex === -1) {
                            dropIndex = e.target.children.length;
                        }
                    }

                    // call the passed drop function
                    $scope.$apply(function($scope) {
                        const targetList = $scope.$eval(attrs.chartDragDropList);
                        const newData = angular.copy($scope.activeDragDrop.data);
                        delete newData.$$hashKey;
                        newData.__justDragDropped = true;

                        if ($scope.activeDragDrop.moveFromList && $scope.activeDragDrop.moveFromList === targetList) {
                            const oldIdx = $scope.activeDragDrop.moveFromListIndex;

                            if (dropIndex > oldIdx && dropIndex > 0) {
                                dropIndex--;
                            }

                            targetList.splice(dropIndex, 0, targetList.splice(oldIdx, 1)[0]);

                        } else if ($scope.activeDragDrop.moveFromList) {
                            targetList.splice(dropIndex, 0, newData);
                            if ($scope.activeDragDrop.moveFromList) {
                                $scope.activeDragDrop.moveFromList.splice($scope.activeDragDrop.moveFromListIndex, 1);
                            }
                        } else {
                            targetList.splice(dropIndex, 0, newData);
                        }

                        // Force remove placeholder right now
                        $scope.removeClassHereAndThere(element, 'drop-accepted');
                        $scope.removeClassHereAndThere(element, 'drop-rejected');
                        placeholder.detach();

                        $scope.onDragEnd();

                        $scope.$emit('dragDropSuccess');
                    });
                    return false;
                }, false);
            }
        };
    });
})();
