(function () {
  "use strict";

  angular.module("dataiku.nestedFilters").directive("inputDateConversion", function () {
    return {
      scope: false,
      restrict: "A",
      link: function ($scope, element, attrs) {
        $scope.$watch(attrs.inputDateConversion, function (nv) {
          if (!nv) return;
          var newVal = nv;
          var curVal = $(element).val();
          if (curVal === newVal) return;

          // If curVal and newVal are different, it means we are loading the date from the model to UI widget
          // newVal is YYYY-MM-DD format and we need a JS date at 00:00:00 in the local timezone for the widget
          var date = new Date(parseInt(newVal.substring(0, 4)), parseInt(newVal.substring(5, 7)) - 1,  parseInt(newVal.substring(8, 10)));

          date.setFullYear(parseInt(newVal.substring(0, 4)), parseInt(newVal.substring(5, 7)) - 1, parseInt(newVal.substring(8, 10)))

          $scope[attrs.ngModel] = date;
          $(element).val(newVal);
        });

        $scope.$watch(attrs.ngModel, function (nv) {
          if (!nv) return;
          var newVal = $(element).val();
          var curVal = $scope.$eval(attrs.inputDateConversion);
          if (curVal === newVal) return;
          // Set the model date as the YYYY-MM-DD string from the element (represents a timezone agnostic date).
          // Do not bother working with nv (evil js date in local timezone)
          $scope.$eval(attrs.inputDateConversion + '="' + newVal + '"');
        });
      },
    };
  });
})();
