(function() {
    "use strict";

    angular.module("dataiku.scheduleScenario").factory("ScheduleScenarioService", ScheduleScenarioService);

    function ScheduleScenarioService(
        WT1,
        DataikuAPI,
        TaggableObjectsUtils,
        translate
    ) {

        async function createScheduledScenario(projectKey, options) {
            return DataikuAPI.scenarios.schedule(projectKey, options)
        }

        const typeToDescription = {
            "DATASET": translate("SCENARIO.SCHEDULE.MODAL.TYPES.DATASET", "dataset"),
            "MANAGED_FOLDER": translate("SCENARIO.SCHEDULE.MODAL.TYPES.MANAGED_FOLDER", "folder"),
            "SAVED_MODEL": translate("SCENARIO.SCHEDULE.MODAL.TYPES.SAVED_MODEL", "model"),
            "MODEL_EVALUATION_STORE": translate("SCENARIO.SCHEDULE.MODAL.TYPES.MODEL_EVALUATION_STORE", "evaluation store"),
            "RETRIEVABLE_KNOWLEDGE": translate("SCENARIO.SCHEDULE.MODAL.TYPES.RETRIEVABLE_KNOWLEDGE", "knowledge bank"),
            "FLOW_ZONE": translate("SCENARIO.SCHEDULE.MODAL.TYPES.FLOW_ZONE", "flow zone"),
            "RECIPE": translate("SCENARIO.SCHEDULE.MODAL.TYPES.RECIPE", "recipe"),
            "MULTIPLE": translate("SCENARIO.SCHEDULE.MODAL.TYPES.MULTIPLE", "these")
        }

        function createJobDef(buildMode, projectKey) {
            return {
                "type": buildMode,
                "refreshHiveMetastore":true,
                "projectKey": projectKey,
                "outputs": []
            };
        }

        function createInitialScenarioName(objectType, selectedObjects) {
            return translate("SCENARIO.SCHEDULE.MODAL.TITLE", "Schedule build of \"{{count == 1 ? name : count + ' items'}}\"", {
                name: selectedObjects[0].description || selectedObjects[0].name,
                count: selectedObjects.length
            })
        }

        function selectedObjectToTaggableObject(object) {
            if (object.nodeType) {
                // the selected object is a Node from the flow
                return TaggableObjectsUtils.fromNode(object)
            } else if (TaggableObjectsUtils.isComputable(object)) {
                // The object is a computable, we don't need to convert it
                return object
            } else if (object.objectType) {
                // The object is a recipe output, we need to transform it
                return {
                    ...object,
                    type: object.objectType,
                    subType: object.type
                }
            } else if (object.interest && object.interest.objectType) {
                // The selected object comes from the Dataset list screen
                return {
                    ...object,
                    type: object.interest.objectType,
                    subType: object.type
                }
            }
            return object
        }


        return {
            typeToDescription,
            createInitialScenarioName,
            createScheduledScenario,
            createJobDef,
            selectedObjectToTaggableObject
        }
    }
})();