(function(){
    "use strict";

    const searchNotebookQueryList = {
        bindings : {
            cells: "<",
            selectedCellId: "<",
            onSelectedCell: "<",
            cellMenu: "<"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-query-list/search-notebook-query-list.component.html",
        controller: function() {
            const $ctrl = this;

            $ctrl.getDisplayedCellName = (cell) => {
                if (cell.name) {
                    return cell.name;
                }
                if (cell.query) {
                    return cell.query;
                }
                return "Unnamed query";
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookQueryList", searchNotebookQueryList);
})();