(function(){
    "use strict";

    const searchNotebookTable = {
        bindings : {
            selectedField: "<",
            schema: "<",
            notebookCell: "<",
            connection: "<",
            cellMenu: "<"
        },
        templateUrl: "/static/dataiku/search-notebooks/search-notebook-table/search-notebook-table.component.html",
        controller: function($element, $scope) {
            const $ctrl = this;
            $scope.elasticSearchIndex = null;

            $ctrl.$onChanges = (changes) => {
                if (changes.selectedField && changes.selectedField.currentValue) {
                    $scope.selectedField = changes.selectedField.currentValue;
                }
                if (changes.schema && changes.schema.currentValue) {
                    $scope.searchNotebookSchema = changes.schema.currentValue;
                }
                if (changes.notebookCell && changes.notebookCell.currentValue) {
                    $scope.notebookCell = changes.notebookCell.currentValue;
                }
                if (changes.connection && changes.connection.currentValue) {
                    $scope.notebookConnection = changes.connection.currentValue;
                }
            };

            $ctrl.getOnIndexText = () => {
                switch($ctrl.notebookCell.searchScope.scope) {
                    case "INDICES":
                        if ($ctrl.notebookCell.searchScope.indices.length === 1) {
                            return `on ${$ctrl.notebookCell.searchScope.indices[0]}`;
                        }
                        return `on ${$ctrl.notebookCell.$mappingStats.indexCount} indices`;
                    case "INDEX_PATTERN":
                        return `on ${$ctrl.notebookCell.searchScope.indexPattern}`;
                    case "DATASETS":
                        return `on ${$ctrl.notebookCell.searchScope.datasets.length} ${$ctrl.notebookCell.searchScope.datasets.length > 1 ? "datasets" : "dataset"}`;
                }
            };
        }
    }

    angular.module("dataiku.searchNotebooks").component("searchNotebookTable", searchNotebookTable);
})();