import dataiku
import pandas as pd
import numpy as np

from datasets import Dataset

from ragas import evaluate as ragas_evaluate
from ragas.metrics._noise_sensitivity import NoiseSensitivity


def evaluate(input_df, recipe_params, interpreted_columns, **kwargs):
    ragas_df = pd.DataFrame()
    ragas_df["user_input"] = input_df[recipe_params.input_column_name]
    ragas_df["response"] = input_df[recipe_params.output_column_name]
    ragas_df["retrieved_contexts"] = input_df[recipe_params.context_column_name].apply(lambda x: [x])
    ragas_df["reference"] = input_df[recipe_params.ground_truth_column_name]

    ret = ragas_evaluate(
        Dataset.from_pandas(ragas_df),
        metrics=[NoiseSensitivity()],
        llm=recipe_params.completion_llm,
        embeddings=recipe_params.embedding_llm
    )

    row_by_row_metrics = ret["noise_sensitivity_relevant"]
    global_metric = np.nanmean(row_by_row_metrics)

    return global_metric, row_by_row_metrics
