import dataiku
from joblib import Parallel, delayed, cpu_count
import pandas as pd

client = dataiku.api_client()

# Set number of parallel jobs
parallel_jobs_count = max(cpu_count() - 1, 1)

# Each variable in this list will be passed to a different job, 1 job = 1 application temporary instance
variables = ["32", "28"]

application_id = "MY_APP_ID"
scenario_id = "MY_SCENARIO_ID"

# Dataset that is built by my scenario inside the app
scenario_output_ds_name = "MY_SCENARIO_OUPUT_DATASET"

# Dataset where i want to write the results of all my parallel jobs in the current project
results_ds_name = "MY_RESULTS_DATASET"

# Clear results dataset before appending scenario output to it
current_project = client.get_default_project()
results_ds = current_project.get_dataset(results_ds_name)
results_ds.clear()

# Kick off a new application temporary instance and run a scenario in it for each variable in the variables list
def run_job(variable):
    
    # Create a temporary instance for my application
    with client.get_app(application_id).create_temporary_instance() as instance:
        
        # Get the project corresponding to this application instance.
        project = instance.get_as_project()

        # Set the project variables in the instance
        variables = project.get_variables()
        variables['standard'].update({'age': variable})
        project.set_variables(variables)

        # Start the scenario
        scenario = project.get_scenario(scenario_id)
        scenario.run_and_wait()
        
        # Do what you want with your project after the scenario has finished
        # Here we copy our scenario output dataset into the results dataset
        dataset = project.get_dataset(scenario_output_ds_name)
        dataset.copy_to(results_ds, write_mode = 'APPEND').wait_for_result()


# Launch jobs in parallel for each variable in the variables list
Parallel(n_jobs=parallel_jobs_count)([delayed(run_job)(variable) for variable in variables])
