<#import "/common/boilerplate.ftl" as boilerplate>
<#import "/common/artifact_utils.ftl" as artifact_utils>
<#import "/common/user_utils.ftl" as user_utils>
<@boilerplate.subject>
    <@user_utils.display userWhoDidAction /> has requested your feedback
    <#if artifact.name??>
        for group<#if requestedGroups?size gt 1>s</#if>
        <#list requestedGroups as userGroup>"${userGroup?truncate(80)}"<#sep>, </#list>
        for "${signoff.title?truncate(80)}" on item "${artifact.name?truncate(80)}"
    <#else>
        on an item you don't have access to
    </#if>
</@boilerplate.subject>
<@boilerplate.mail>
    <p>Hello ${notificationRecipient.displayName?truncate(80)},</p>
    <#if artifact.name??> <#-- If has read permissions -->
        <p>
            <@user_utils.display userWhoDidAction /> has requested your feedback for the sign-off "${signoff.title?truncate(80)}" on the item "${artifact.name?truncate(80)}".
        </p>
        <p>
            Your feedback is expected on group<#if requestedGroups?size = 1> "${requestedGroups?first?truncate(80)}".<#else>s :<br /><ul><#list requestedGroups as userGroup><li>${userGroup?truncate(80)}</li></#list></ul></#if>
        </p>
        <#include "/signoffs/components/signoff_link.ftl">
        <#include "/signoffs/components/more_info.ftl">
    <#else> <#-- If no permissions -->
        <p><@user_utils.display userWhoDidAction /> has requested your feedback for a sign-off on item <@artifact_utils.link artifact>${artifact.id}</@artifact_utils.link>.</p>
        <p>You do not have access to this item. Please contact an administrator to get access.</p>
    </#if>
</@boilerplate.mail>
