CREATE TABLE artifact_subscriptions (
    artifact_subscription_artifact_id TEXT GENERATED ALWAYS AS ((artifact_subscription_json -> 'subscriptionId' ->> 'artifactId')::TEXT) STORED NOT NULL REFERENCES artifacts,
    artifact_subscription_user_login TEXT GENERATED ALWAYS AS ((artifact_subscription_json -> 'subscriptionId' ->> 'userLogin')::TEXT) STORED NOT NULL,
    artifact_subscription_json JSONB NOT NULL,
    PRIMARY KEY (artifact_subscription_artifact_id, artifact_subscription_user_login)
);
CREATE INDEX artifact_subscriptions_user_login_index ON artifact_subscriptions (artifact_subscription_user_login);

CREATE TABLE artifact_subscriptions_history (
    artifact_subscription_artifact_id TEXT GENERATED ALWAYS AS ((artifact_subscription_json -> 'subscriptionId' ->> 'artifactId')::TEXT) STORED NOT NULL,
    artifact_subscription_user_login TEXT GENERATED ALWAYS AS ((artifact_subscription_json -> 'subscriptionId' ->> 'userLogin')::TEXT) STORED NOT NULL,
    artifact_subscription_json JSONB NOT NULL,
    PRIMARY KEY (_revision_id)
) INHERITS (_history_revisions);
CREATE INDEX artifact_subscriptions_history_pk_index ON artifact_subscriptions_history (artifact_subscription_artifact_id, artifact_subscription_user_login);
CREATE INDEX artifact_subscriptions_history_user_login_index ON artifact_subscriptions_history (artifact_subscription_user_login);