/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.defaults.internal;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructType;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;

public class DefaultKernelUtils {
    private static final DateTimeFormatter DEFAULT_JSON_TIMESTAMPNTZ_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").optionalStart().appendFraction(ChronoField.MICRO_OF_SECOND, 0, 6, true).optionalEnd().toFormatter();
    static int JULIAN_DAY_OF_EPOCH = 2440588;

    private DefaultKernelUtils() {
    }

    public static long fromJulianDay(int n, long l) {
        return (long)(n - JULIAN_DAY_OF_EPOCH) * 86400000000L + l / 1000L;
    }

    public static Tuple2<Integer, Long> toJulianDay(long l) {
        long l2 = l + (long)JULIAN_DAY_OF_EPOCH * 86400000000L;
        long l3 = l2 / 86400000000L;
        long l4 = l2 % 86400000000L;
        return new Tuple2((Object)((int)l3), (Object)TimeUnit.MICROSECONDS.toNanos(l4));
    }

    public static long millisToMicros(long l) {
        return Math.multiplyExact(l, 1000L);
    }

    public static long daysToMicros(int n, ZoneOffset zoneOffset) {
        long l = LocalDate.ofEpochDay(n).atStartOfDay(zoneOffset).toEpochSecond();
        return l * 1000000L;
    }

    public static long parseTimestampNTZ(String string) {
        LocalDateTime localDateTime = LocalDateTime.parse(string, DEFAULT_JSON_TIMESTAMPNTZ_FORMATTER);
        Instant instant = localDateTime.toInstant(ZoneOffset.UTC);
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }

    public static DataType getDataType(StructType structType, Column column) {
        StructType structType2 = structType;
        for (String string : column.getNames()) {
            if (!(structType2 instanceof StructType)) {
                throw new IllegalArgumentException(String.format("Cannot resolve column (%s) in schema: %s", column, structType));
            }
            StructType structType3 = structType2;
            if (!structType3.fieldNames().contains(string)) {
                throw new IllegalArgumentException(String.format("Cannot resolve column (%s) in schema: %s", column, structType));
            }
            structType2 = structType3.get(string).getDataType();
        }
        return structType2;
    }
}

