/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.viterbi;

import com.atilika.kuromoji.TokenizerBase;
import com.atilika.kuromoji.dict.CharacterDefinitions;
import com.atilika.kuromoji.dict.TokenInfoDictionary;
import com.atilika.kuromoji.dict.UnknownDictionary;
import com.atilika.kuromoji.dict.UserDictionary;
import com.atilika.kuromoji.trie.DoubleArrayTrie;
import com.atilika.kuromoji.viterbi.ViterbiLattice;
import com.atilika.kuromoji.viterbi.ViterbiNode;
import java.util.ArrayList;
import java.util.List;

public class ViterbiBuilder {
    private final DoubleArrayTrie trie;
    private final TokenInfoDictionary dictionary;
    private final UnknownDictionary unknownDictionary;
    private final UserDictionary userDictionary;
    private final CharacterDefinitions characterDefinitions;
    private final boolean useUserDictionary;
    private boolean searchMode;

    public ViterbiBuilder(DoubleArrayTrie trie, TokenInfoDictionary dictionary, UnknownDictionary unknownDictionary, UserDictionary userDictionary, TokenizerBase.Mode mode) {
        this.trie = trie;
        this.dictionary = dictionary;
        this.unknownDictionary = unknownDictionary;
        this.userDictionary = userDictionary;
        boolean bl = this.useUserDictionary = userDictionary != null;
        if (mode == TokenizerBase.Mode.SEARCH || mode == TokenizerBase.Mode.EXTENDED) {
            this.searchMode = true;
        }
        this.characterDefinitions = unknownDictionary.getCharacterDefinition();
    }

    public ViterbiLattice build(String text) {
        int textLength = text.length();
        ViterbiLattice lattice = new ViterbiLattice(textLength + 2);
        lattice.addBos();
        int unknownWordEndIndex = -1;
        for (int startIndex = 0; startIndex < textLength; ++startIndex) {
            if (!lattice.tokenEndsWhereCurrentTokenStarts(startIndex)) continue;
            String suffix = text.substring(startIndex);
            boolean found = this.processIndex(lattice, startIndex, suffix);
            if (!this.searchMode && unknownWordEndIndex > startIndex) continue;
            int[] categories = this.characterDefinitions.lookupCategories(suffix.charAt(0));
            for (int i = 0; i < categories.length; ++i) {
                int category = categories[i];
                unknownWordEndIndex = this.processUnknownWord(category, i, lattice, unknownWordEndIndex, startIndex, suffix, found);
            }
        }
        if (this.useUserDictionary) {
            this.processUserDictionary(text, lattice);
        }
        lattice.addEos();
        return lattice;
    }

    private boolean processIndex(ViterbiLattice lattice, int startIndex, String suffix) {
        boolean found = false;
        for (int endIndex = 1; endIndex < suffix.length() + 1; ++endIndex) {
            String prefix = suffix.substring(0, endIndex);
            int result = this.trie.lookup(prefix, 0, 0);
            if (result > 0) {
                found = true;
                for (int wordId : this.dictionary.lookupWordIds(result)) {
                    ViterbiNode node = new ViterbiNode(wordId, prefix, this.dictionary, startIndex, ViterbiNode.Type.KNOWN);
                    lattice.addNode(node, startIndex + 1, startIndex + 1 + endIndex);
                }
                continue;
            }
            if (result < 0) break;
        }
        return found;
    }

    private int processUnknownWord(int category, int i, ViterbiLattice lattice, int unknownWordEndIndex, int startIndex, String suffix, boolean found) {
        int unknownWordLength = 0;
        int[] definition = this.characterDefinitions.lookupDefinition(category);
        if (definition[0] == 1 || !found) {
            if (definition[1] == 0) {
                unknownWordLength = 1;
            } else {
                char c;
                int[] categories;
                unknownWordLength = 1;
                for (int j = 1; j < suffix.length() && (categories = this.characterDefinitions.lookupCategories(c = suffix.charAt(j))) != null && i < categories.length && category == categories[i]; ++j) {
                    ++unknownWordLength;
                }
            }
        }
        if (unknownWordLength > 0) {
            int[] wordIds;
            String unkWord = suffix.substring(0, unknownWordLength);
            for (int wordId : wordIds = this.unknownDictionary.lookupWordIds(category)) {
                ViterbiNode node = new ViterbiNode(wordId, unkWord, this.unknownDictionary, startIndex, ViterbiNode.Type.UNKNOWN);
                lattice.addNode(node, startIndex + 1, startIndex + 1 + unknownWordLength);
            }
            unknownWordEndIndex = startIndex + unknownWordLength;
        }
        return unknownWordEndIndex;
    }

    private void processUserDictionary(String text, ViterbiLattice lattice) {
        List<UserDictionary.UserDictionaryMatch> matches = this.userDictionary.findUserDictionaryMatches(text);
        for (UserDictionary.UserDictionaryMatch match : matches) {
            int wordId = match.getWordId();
            int index = match.getMatchStartIndex();
            int length = match.getMatchLength();
            String word = text.substring(index, index + length);
            ViterbiNode node = new ViterbiNode(wordId, word, this.userDictionary, index, ViterbiNode.Type.USER);
            int nodeStartIndex = index + 1;
            int nodeEndIndex = nodeStartIndex + length;
            lattice.addNode(node, nodeStartIndex, nodeEndIndex);
            if (this.isLatticeBrokenBefore(nodeStartIndex, lattice)) {
                this.repairBrokenLatticeBefore(lattice, index);
            }
            if (!this.isLatticeBrokenAfter(nodeStartIndex + length, lattice)) continue;
            this.repairBrokenLatticeAfter(lattice, nodeEndIndex);
        }
    }

    private boolean isLatticeBrokenBefore(int nodeIndex, ViterbiLattice lattice) {
        ViterbiNode[][] nodeEndIndices = lattice.getEndIndexArr();
        return nodeEndIndices[nodeIndex] == null;
    }

    private boolean isLatticeBrokenAfter(int endIndex, ViterbiLattice lattice) {
        ViterbiNode[][] nodeStartIndices = lattice.getStartIndexArr();
        return nodeStartIndices[endIndex] == null;
    }

    private void repairBrokenLatticeBefore(ViterbiLattice lattice, int index) {
        ViterbiNode[][] nodeStartIndices = lattice.getStartIndexArr();
        for (int startIndex = index; startIndex > 0; --startIndex) {
            ViterbiNode glueBase;
            if (nodeStartIndices[startIndex] == null || (glueBase = this.findGlueNodeCandidate(index, nodeStartIndices[startIndex], startIndex)) == null) continue;
            int length = index + 1 - startIndex;
            String surface = glueBase.getSurface().substring(0, length);
            ViterbiNode glueNode = this.createGlueNode(startIndex, glueBase, surface);
            lattice.addNode(glueNode, startIndex, startIndex + glueNode.getSurface().length());
            return;
        }
    }

    private void repairBrokenLatticeAfter(ViterbiLattice lattice, int nodeEndIndex) {
        ViterbiNode[][] nodeEndIndices = lattice.getEndIndexArr();
        for (int endIndex = nodeEndIndex + 1; endIndex < nodeEndIndices.length; ++endIndex) {
            ViterbiNode glueBase;
            if (nodeEndIndices[endIndex] == null || (glueBase = this.findGlueNodeCandidate(nodeEndIndex, nodeEndIndices[endIndex], endIndex)) == null) continue;
            int delta = endIndex - nodeEndIndex;
            String glueBaseSurface = glueBase.getSurface();
            String surface = glueBaseSurface.substring(glueBaseSurface.length() - delta);
            ViterbiNode glueNode = this.createGlueNode(nodeEndIndex, glueBase, surface);
            lattice.addNode(glueNode, nodeEndIndex, nodeEndIndex + glueNode.getSurface().length());
            return;
        }
    }

    private ViterbiNode findGlueNodeCandidate(int index, ViterbiNode[] latticeNodes, int startIndex) {
        ArrayList<ViterbiNode> candidates = new ArrayList<ViterbiNode>();
        for (ViterbiNode viterbiNode : latticeNodes) {
            if (viterbiNode == null) continue;
            candidates.add(viterbiNode);
        }
        if (!candidates.isEmpty()) {
            ViterbiNode glueBase = null;
            int length = index + 1 - startIndex;
            for (ViterbiNode candidate : candidates) {
                if (!this.isAcceptableCandidate(length, glueBase, candidate)) continue;
                glueBase = candidate;
            }
            if (glueBase != null) {
                return glueBase;
            }
        }
        return null;
    }

    private boolean isAcceptableCandidate(int targetLength, ViterbiNode glueBase, ViterbiNode candidate) {
        return (glueBase == null || candidate.getSurface().length() < glueBase.getSurface().length()) && candidate.getSurface().length() >= targetLength;
    }

    private ViterbiNode createGlueNode(int startIndex, ViterbiNode glueBase, String surface) {
        return new ViterbiNode(glueBase.getWordId(), surface, glueBase.getLeftId(), glueBase.getRightId(), glueBase.getWordCost(), startIndex, ViterbiNode.Type.INSERTED);
    }
}

