/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.ooxml;

import com.dataiku.dss.shadelibpoi.com.github.pjfanning.xlsx.impl.ooxml.TempDataStore;
import com.dataiku.dss.shadelibpoi.org.apache.poi.util.TempFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TempFileDataStore
implements TempDataStore {
    private static final Logger log = LoggerFactory.getLogger(TempFileDataStore.class);
    private File tempFile;

    TempFileDataStore() {
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.tempFile != null) {
            throw new IOException("temp file already created");
        }
        this.tempFile = TempFile.createTempFile("excel-streaming-reader", ".xml");
        return new FileOutputStream(this.tempFile);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.tempFile == null) {
            throw new IOException("temp file was never populated");
        }
        return new FileInputStream(this.tempFile);
    }

    @Override
    public void close() throws IOException {
        if (this.tempFile != null && !this.tempFile.delete()) {
            log.debug("failed to delete temp file");
        }
    }
}

