/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibpoi.org.apache.commons.math3.distribution;

import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.distribution.MultivariateRealDistribution;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.exception.util.Localizable;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.exception.util.LocalizedFormats;
import com.dataiku.dss.shadelibpoi.org.apache.commons.math3.random.RandomGenerator;

public abstract class AbstractMultivariateRealDistribution
implements MultivariateRealDistribution {
    protected final RandomGenerator random;
    private final int dimension;

    protected AbstractMultivariateRealDistribution(RandomGenerator rng, int n) {
        this.random = rng;
        this.dimension = n;
    }

    public void reseedRandomGenerator(long seed) {
        this.random.setSeed(seed);
    }

    public int getDimension() {
        return this.dimension;
    }

    public abstract double[] sample();

    public double[][] sample(int sampleSize) {
        if (sampleSize <= 0) {
            throw new NotStrictlyPositiveException((Localizable)LocalizedFormats.NUMBER_OF_SAMPLES, sampleSize);
        }
        double[][] out = new double[sampleSize][this.dimension];
        for (int i = 0; i < sampleSize; ++i) {
            out[i] = this.sample();
        }
        return out;
    }
}

