/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.connection;

import java.io.IOException;
import net.snowflake.ingest.connection.HistoryRangeResponse;
import net.snowflake.ingest.connection.HistoryResponse;
import net.snowflake.ingest.connection.IngestResponse;
import net.snowflake.ingest.connection.IngestResponseException;
import net.snowflake.ingest.internal.apache.http.HttpResponse;
import net.snowflake.ingest.internal.apache.http.StatusLine;
import net.snowflake.ingest.internal.apache.http.util.EntityUtils;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.DeserializationFeature;
import net.snowflake.ingest.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.ingest.utils.BackOffException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceResponseHandler.class);
    static ObjectMapper mapper = new ObjectMapper();

    private static boolean isStatusOK(StatusLine statusLine) {
        return statusLine.getStatusCode() >= 200 && statusLine.getStatusCode() < 300;
    }

    public static IngestResponse unmarshallIngestResponse(HttpResponse response) throws IOException, IngestResponseException {
        if (response == null) {
            LOGGER.warn("Null argument passed to unmarshallIngestResponse");
            throw new IllegalArgumentException();
        }
        StatusLine statusLine = response.getStatusLine();
        if (!ServiceResponseHandler.isStatusOK(statusLine)) {
            LOGGER.warn("Exceptional Status Code found in unmarshallInsert Response  - {}", (Object)statusLine.getStatusCode());
            ServiceResponseHandler.handleExceptionalStatus(statusLine, response);
            return null;
        }
        String blob = EntityUtils.toString(response.getEntity());
        return mapper.readValue(blob, IngestResponse.class);
    }

    public static HistoryResponse unmarshallHistoryResponse(HttpResponse response) throws IOException, IngestResponseException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallHistoryResponse");
            throw new IllegalArgumentException();
        }
        StatusLine line = response.getStatusLine();
        if (!ServiceResponseHandler.isStatusOK(line)) {
            LOGGER.warn("Exceptional Status Code found in unmarshallHistoryResponse - {}", (Object)line.getStatusCode());
            ServiceResponseHandler.handleExceptionalStatus(line, response);
            return null;
        }
        String blob = EntityUtils.toString(response.getEntity());
        return mapper.readValue(blob, HistoryResponse.class);
    }

    public static HistoryRangeResponse unmarshallHistoryRangeResponse(HttpResponse response) throws IOException, IngestResponseException {
        if (response == null) {
            LOGGER.warn("Null response passed to unmarshallHistoryRangeResponse");
            throw new IllegalArgumentException();
        }
        StatusLine line = response.getStatusLine();
        if (!ServiceResponseHandler.isStatusOK(line)) {
            LOGGER.warn("Exceptional Status Code found in unmarshallHistoryRangeResponse - {}", (Object)line.getStatusCode());
            ServiceResponseHandler.handleExceptionalStatus(line, response);
            return null;
        }
        String blob = EntityUtils.toString(response.getEntity());
        return mapper.readValue(blob, HistoryRangeResponse.class);
    }

    private static void handleExceptionalStatus(StatusLine statusLine, HttpResponse response) throws IOException, IngestResponseException {
        switch (statusLine.getStatusCode()) {
            case 503: {
                LOGGER.warn("503 Status hit, backoff");
                throw new BackOffException();
            }
        }
        LOGGER.error("Status code {} found in response from service", (Object)statusLine.getStatusCode());
        String blob = EntityUtils.toString(response.getEntity());
        throw new IngestResponseException(statusLine.getStatusCode(), IngestResponseException.IngestExceptionBody.parseBody(blob));
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

