/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

public class GsonNanToNullTypeAdaptorFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final Class rawType = type.getRawType();
        if (rawType != Double.TYPE && rawType != Float.TYPE && rawType != Double.class && rawType != Float.class) {
            return null;
        }
        return new TypeAdapter<T>(){

            private Double mapToNull(Double dbl) {
                if (dbl == null || dbl.isNaN() || dbl.isInfinite()) {
                    return null;
                }
                return dbl;
            }

            private Float mapToNull(Float flt) {
                if (flt == null || flt.isNaN() || flt.isInfinite()) {
                    return null;
                }
                return flt;
            }

            public void write(JsonWriter out, T value) throws IOException {
                if (rawType == Double.TYPE || rawType == Double.class) {
                    Double dbl = this.mapToNull((Double)value);
                    if (dbl == null) {
                        out.nullValue();
                    } else {
                        out.value(dbl.doubleValue());
                    }
                } else {
                    Float dbl = this.mapToNull((Float)value);
                    if (dbl == null) {
                        out.nullValue();
                    } else {
                        out.value((double)dbl.floatValue());
                    }
                }
            }

            public T read(JsonReader reader) throws IOException {
                if (reader.peek() == JsonToken.NULL) {
                    reader.nextNull();
                    if (rawType == Double.class || rawType == Float.class) {
                        return null;
                    }
                    if (rawType == Double.TYPE) {
                        return new Double(Double.NaN);
                    }
                    if (rawType == Float.TYPE) {
                        return new Float(Float.NaN);
                    }
                }
                if (rawType == Double.TYPE || rawType == Double.class) {
                    return new Double(reader.nextDouble());
                }
                return new Float(reader.nextDouble());
            }
        };
    }
}

