/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.utils.StreamFilter;
import java.util.ArrayList;
import java.util.List;

public class StreamReplacement
implements StreamFilter {
    private List<StringPair> replacementString;
    private int minCache;
    private String buffer = "";

    StreamReplacement(List<StringPair> replacementString) {
        this.replacementString = replacementString;
        this.minCache = 1;
        for (StringPair pair : replacementString) {
            this.minCache = Math.max(pair.getSource().length(), this.minCache);
        }
        --this.minCache;
    }

    public StreamReplacement(String source, String destination) {
        this.replacementString = new ArrayList<StringPair>();
        this.replacementString.add(new StringPair(source, destination));
        this.minCache = source.length() - 1;
    }

    @Override
    public String transform(String str, boolean availableBytes) {
        return this.transform(str, availableBytes, -1);
    }

    private String transform(String str, boolean availableBytes, int start_idx) {
        int outputSize;
        str = this.buffer + (String)str;
        this.buffer = "";
        if (((String)str).length() < this.minCache) {
            if (!availableBytes) {
                return str;
            }
            this.buffer = str;
            return "";
        }
        int best_idx = Integer.MAX_VALUE;
        StringPair best_pair = null;
        for (StringPair pair : this.replacementString) {
            int index = ((String)str).indexOf(pair.getSource(), start_idx);
            if (index == -1 || index >= best_idx) continue;
            best_idx = index;
            best_pair = pair;
        }
        if (best_pair != null) {
            str = ((String)str).substring(0, best_idx) + best_pair.getDestination() + ((String)str).substring(best_idx + best_pair.getSource().length());
            return this.transform((String)str, availableBytes, start_idx + best_pair.getDestination().length());
        }
        int n = outputSize = availableBytes ? ((String)str).length() - this.minCache : ((String)str).length();
        assert (outputSize >= 0);
        this.buffer = ((String)str).substring(outputSize);
        return ((String)str).substring(0, outputSize);
    }

    public List<StringPair> getReplacementString() {
        return this.replacementString;
    }

    public void setReplacementString(List<StringPair> replacementString) {
        this.replacementString = replacementString;
    }

    public StreamReplacement withReplacementString(List<StringPair> replacementString) {
        this.replacementString = replacementString;
        return this;
    }

    public int getCacheSize() {
        return this.buffer.length();
    }

    public static class StringPair {
        private String source;
        private String destination;

        public StringPair(String source, String destination) {
            this.source = source;
            this.destination = destination;
        }

        public String getSource() {
            return this.source;
        }

        public void setSource(String source) {
            this.source = source;
        }

        public StringPair withSource(String source) {
            this.source = source;
            return this;
        }

        public String getDestination() {
            return this.destination;
        }

        public void setDestination(String destination) {
            this.destination = destination;
        }

        public StringPair withDestination(String destination) {
            this.destination = destination;
            return this;
        }
    }
}

