/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.polyjson;

import com.dataiku.dss.shadelib.org.apache.commons.lang3.StringUtils;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.TypeAdapter;
import com.google.gson.internal.JsonReaderInternalAccess;
import com.google.gson.internal.UnsafeAllocator;
import com.google.gson.internal.bind.TypeAdapters;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;

public class RichJsonReader
extends JsonReader {
    private static Boolean HAS_GET_PATH = null;
    private JsonReader backingReader;
    private List<JsonToken> tokenBuffer;
    private List<String> valueBuffer;
    private int tokenPtr;
    private int valuePtr;
    private String initialPath;
    private JsonToken consumedToken;
    private String consumedValue;
    private LookaheadContext lookaheadContext;
    private static final String BOOLEAN_TRUE = "true";
    private static final String BOOLEAN_FALSE = "false";
    private static final UnsafeAllocator UNSAFE_ALLOCATOR = UnsafeAllocator.create();
    private static final Pattern JSONPATH_TOKENIZER = Pattern.compile("^([^.\\[\\]]*)|\\[(\\d+)]|\\.([^.\\[\\]]*)", 32);
    private static Logger logger;

    private RichJsonReader() {
        super(null);
    }

    private static RichJsonReader newInstance() {
        try {
            return (RichJsonReader)((Object)UNSAFE_ALLOCATOR.newInstance(RichJsonReader.class));
        }
        catch (Exception e) {
            throw new RuntimeException("Can't allocate " + String.valueOf(RichJsonReader.class), e);
        }
    }

    public static RichJsonReader fromReader(JsonReader reader) {
        if (reader instanceof RichJsonReader) {
            return (RichJsonReader)reader;
        }
        RichJsonReader richReader = RichJsonReader.newInstance();
        richReader.backingReader = reader;
        richReader.tokenPtr = -1;
        richReader.valuePtr = -1;
        richReader.tokenBuffer = new ArrayList<JsonToken>();
        richReader.valueBuffer = new ArrayList<String>();
        return richReader;
    }

    private String getBackingReaderPathSafe() {
        if (HAS_GET_PATH != null && !HAS_GET_PATH.booleanValue()) {
            return "[cannot infer]";
        }
        try {
            HAS_GET_PATH = true;
            return this.backingReader.getPath();
        }
        catch (NoSuchMethodError e) {
            logger.warn((Object)"Unable to infer location in json object for error messages");
            HAS_GET_PATH = false;
            return "[cannot infer]";
        }
    }

    public void beginLookahead() {
        LookaheadContext newLookaheadContext = new LookaheadContext();
        newLookaheadContext.parent = this.lookaheadContext;
        newLookaheadContext.prevTokenPtr = this.tokenPtr == -1 ? this.tokenBuffer.size() : this.tokenPtr;
        int n = newLookaheadContext.prevStringPtr = this.valuePtr == -1 ? this.valueBuffer.size() : this.valuePtr;
        if (this.lookaheadContext == null && this.tokenPtr == -1) {
            this.initialPath = this.getBackingReaderPathSafe();
        }
        this.lookaheadContext = newLookaheadContext;
    }

    public void endLookahead() {
        if (this.lookaheadContext == null) {
            throw new IllegalStateException("Was not doing a lookahead at " + this.getPath());
        }
        this.tokenPtr = this.lookaheadContext.prevTokenPtr;
        this.valuePtr = this.lookaheadContext.prevStringPtr;
        this.lookaheadContext = this.lookaheadContext.parent;
    }

    public void beginArray() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.BEGIN_ARRAY) {
                this.throwUnexpectedToken(JsonToken.BEGIN_ARRAY);
            }
            return;
        }
        this.backingReader.beginArray();
    }

    public void endArray() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.END_ARRAY) {
                this.throwUnexpectedToken(JsonToken.END_ARRAY);
            }
            return;
        }
        this.backingReader.endArray();
    }

    public void beginObject() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.BEGIN_OBJECT) {
                this.throwUnexpectedToken(JsonToken.BEGIN_OBJECT);
            }
            return;
        }
        this.backingReader.beginObject();
    }

    public void endObject() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.END_OBJECT) {
                this.throwUnexpectedToken(JsonToken.END_OBJECT);
            }
        } else {
            this.backingReader.endObject();
        }
    }

    public boolean hasNext() throws IOException {
        if (this.tokenPtr != -1) {
            JsonToken token = this.tokenBuffer.get(this.tokenPtr);
            return token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT;
        }
        return this.backingReader.hasNext();
    }

    public JsonToken peek() throws IOException {
        if (this.tokenPtr != -1) {
            return this.tokenBuffer.get(this.tokenPtr);
        }
        return this.backingReader.peek();
    }

    public String nextName() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.NAME) {
                this.throwUnexpectedToken(JsonToken.NAME);
            }
            return this.consumedValue;
        }
        return this.backingReader.nextName();
    }

    public String nextString() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.STRING && this.consumedToken != JsonToken.NUMBER && this.consumedToken != JsonToken.NAME) {
                this.throwUnexpectedToken(JsonToken.STRING);
            }
            return this.consumedValue;
        }
        return this.backingReader.nextString();
    }

    public boolean isNullValue() throws IOException {
        return this.peek() == JsonToken.NULL;
    }

    @Nullable
    public String nextStringOrNull() throws IOException {
        if (this.isNullValue()) {
            this.nextNull();
            return null;
        }
        return this.nextString();
    }

    public void replacePreviousString(String newValue) {
        int curValuePtr;
        if (this.lookaheadContext == null) {
            throw new IllegalArgumentException("No lookahead session is active at " + this.getPath());
        }
        int curTokenPtr = this.tokenPtr == -1 ? this.tokenBuffer.size() : this.tokenPtr;
        int n = curValuePtr = this.valuePtr == -1 ? this.valueBuffer.size() : this.valuePtr;
        if (curTokenPtr <= 0) {
            throw new IllegalArgumentException("Empty buffer at " + this.getPath());
        }
        JsonToken prevToken = this.tokenBuffer.get(curTokenPtr - 1);
        if (prevToken != JsonToken.STRING) {
            throw new IllegalArgumentException("Previous value was not a string at " + this.getPath());
        }
        this.valueBuffer.set(curValuePtr - 1, newValue);
    }

    private void replayNextToken() {
        this.consumedToken = this.tokenBuffer.get(this.tokenPtr++);
        this.consumedValue = null;
        switch (this.consumedToken) {
            case NUMBER: 
            case NAME: 
            case STRING: 
            case BOOLEAN: {
                this.consumedValue = this.valueBuffer.get(this.valuePtr++);
            }
        }
        if (this.tokenPtr == this.tokenBuffer.size()) {
            this.tokenPtr = -1;
            this.valuePtr = -1;
        }
        if (this.lookaheadContext == null && this.tokenPtr == -1) {
            this.valueBuffer.clear();
            this.tokenBuffer.clear();
            this.initialPath = null;
        }
    }

    private void recordNextToken() throws IOException {
        this.consumedToken = this.backingReader.peek();
        this.tokenBuffer.add(this.consumedToken);
        this.consumedValue = null;
        switch (this.consumedToken) {
            case BOOLEAN: {
                this.consumedValue = this.backingReader.nextBoolean() ? BOOLEAN_TRUE : BOOLEAN_FALSE;
                this.valueBuffer.add(this.consumedValue);
                break;
            }
            case NUMBER: 
            case STRING: {
                this.consumedValue = this.backingReader.nextString();
                this.valueBuffer.add(this.consumedValue);
                break;
            }
            case NAME: {
                this.consumedValue = this.backingReader.nextName();
                this.valueBuffer.add(this.consumedValue);
                break;
            }
            case NULL: {
                this.backingReader.nextNull();
                break;
            }
            case BEGIN_ARRAY: {
                this.backingReader.beginArray();
                break;
            }
            case END_ARRAY: {
                this.backingReader.endArray();
                break;
            }
            case BEGIN_OBJECT: {
                this.backingReader.beginObject();
                break;
            }
            case END_OBJECT: {
                this.backingReader.endObject();
                break;
            }
        }
    }

    private boolean recordOrReplayNextToken() throws IOException {
        if (this.tokenPtr != -1) {
            this.replayNextToken();
            return true;
        }
        if (this.lookaheadContext != null) {
            this.recordNextToken();
            return true;
        }
        return false;
    }

    private void throwUnexpectedToken(JsonToken mainExpectedToken) throws MalformedJsonException {
        throw new MalformedJsonException("Expected " + String.valueOf(mainExpectedToken) + ", got " + String.valueOf(this.consumedToken) + " at " + this.getPath());
    }

    public JsonElement nextJsonElement() throws IOException {
        return (JsonElement)this.nextJsonElement(TypeAdapters.JSON_ELEMENT);
    }

    public <T> T nextJsonElement(TypeAdapter<T> adapter) throws IOException {
        RichJsonReader reader = this.tokenPtr == -1 && this.lookaheadContext == null ? this.backingReader : this;
        return (T)adapter.read((JsonReader)reader);
    }

    public <T> T nextJsonElement(Gson gson, Class<T> clazz) throws IOException {
        TypeAdapter adapter = gson.getAdapter(clazz);
        return this.nextJsonElement(adapter);
    }

    public boolean nextBoolean() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.BOOLEAN) {
                this.throwUnexpectedToken(JsonToken.BOOLEAN);
            }
            return this.consumedValue == BOOLEAN_TRUE;
        }
        return this.backingReader.nextBoolean();
    }

    public void nextNull() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.NULL) {
                this.throwUnexpectedToken(JsonToken.NULL);
            }
            return;
        }
        this.backingReader.nextNull();
    }

    public double nextDouble() throws IOException {
        if (this.recordOrReplayNextToken()) {
            if (this.consumedToken != JsonToken.NUMBER && this.consumedToken != JsonToken.STRING && this.consumedToken != JsonToken.NAME) {
                this.throwUnexpectedToken(JsonToken.NUMBER);
            }
            double value = Double.parseDouble(this.consumedValue);
            if (!this.isLenient() && (Double.isNaN(value) || Double.isInfinite(value))) {
                throw new MalformedJsonException("JSON forbids NaN and infinities: " + value + " at " + this.getPath());
            }
            return value;
        }
        return this.backingReader.nextDouble();
    }

    public long nextLong() throws IOException {
        if (this.recordOrReplayNextToken()) {
            long result;
            block4: {
                if (this.consumedToken != JsonToken.NUMBER && this.consumedToken != JsonToken.STRING && this.consumedToken != JsonToken.NAME) {
                    this.throwUnexpectedToken(JsonToken.NUMBER);
                }
                try {
                    result = Long.parseLong(this.consumedValue);
                }
                catch (NumberFormatException e) {
                    double asDouble = Double.parseDouble(this.consumedValue);
                    result = (long)asDouble;
                    if ((double)result == asDouble) break block4;
                    throw new NumberFormatException("Expected a long but was " + this.consumedValue + " at path " + this.getPath());
                }
            }
            return result;
        }
        return this.backingReader.nextLong();
    }

    public int nextInt() throws IOException {
        if (this.recordOrReplayNextToken()) {
            int result;
            block4: {
                if (this.consumedToken != JsonToken.NUMBER && this.consumedToken != JsonToken.STRING && this.consumedToken != JsonToken.NAME) {
                    this.throwUnexpectedToken(JsonToken.NUMBER);
                }
                try {
                    result = Integer.parseInt(this.consumedValue);
                }
                catch (NumberFormatException e) {
                    double asDouble = Double.parseDouble(this.consumedValue);
                    result = (int)asDouble;
                    if ((double)result == asDouble) break block4;
                    throw new NumberFormatException("Expected an int but was " + this.consumedValue + " at path " + this.getPath());
                }
            }
            return result;
        }
        return this.backingReader.nextInt();
    }

    public void close() throws IOException {
        this.backingReader.close();
    }

    public void skipValue() throws IOException {
        int stackLevel = 0;
        do {
            if (this.recordOrReplayNextToken()) {
                switch (this.consumedToken) {
                    case END_ARRAY: 
                    case END_OBJECT: {
                        --stackLevel;
                        break;
                    }
                    case BEGIN_ARRAY: 
                    case BEGIN_OBJECT: {
                        ++stackLevel;
                    }
                }
            } else {
                switch (this.backingReader.peek()) {
                    case END_ARRAY: {
                        --stackLevel;
                        this.backingReader.endArray();
                        break;
                    }
                    case END_OBJECT: {
                        --stackLevel;
                        this.backingReader.endObject();
                        break;
                    }
                    default: {
                        this.backingReader.skipValue();
                    }
                }
            }
            if (stackLevel >= 0) continue;
            throw new IllegalStateException("No value to skip at " + this.getPath());
        } while (stackLevel > 0);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " at " + this.getPath();
    }

    public String getPath() {
        if (this.tokenPtr == -1) {
            return this.getBackingReaderPathSafe();
        }
        assert (this.initialPath != null);
        Stack<PathElement> stack = new Stack<PathElement>();
        Matcher matcher = JSONPATH_TOKENIZER.matcher(this.initialPath);
        while (matcher.find()) {
            String name;
            String index = matcher.group(2);
            if (index != null) {
                PathElement elt = new PathElement();
                elt.index = Integer.parseInt(index);
                elt.token = JsonToken.BEGIN_ARRAY;
                stack.add(elt);
            }
            if ((name = matcher.group(3)) == null) continue;
            PathElement elt = new PathElement();
            elt.name = name;
            elt.token = JsonToken.BEGIN_OBJECT;
            stack.add(elt);
        }
        int tokIdx = 0;
        int valIdx = 0;
        while (tokIdx < this.tokenPtr) {
            JsonToken token = this.tokenBuffer.get(tokIdx++);
            switch (token) {
                case BEGIN_ARRAY: 
                case BEGIN_OBJECT: {
                    PathElement elt = new PathElement();
                    elt.token = token;
                    elt.index = 0;
                    elt.name = null;
                    stack.push(elt);
                    break;
                }
                case END_ARRAY: 
                case END_OBJECT: {
                    if (stack.empty()) break;
                    stack.pop();
                    ++((PathElement)stack.peek()).index;
                    break;
                }
                case NULL: {
                    if (stack.empty()) break;
                    ++((PathElement)stack.peek()).index;
                    break;
                }
                case NAME: {
                    if (stack.empty()) break;
                    ((PathElement)stack.peek()).name = this.valueBuffer.get(valIdx++);
                    break;
                }
                case NUMBER: 
                case STRING: 
                case BOOLEAN: {
                    if (stack.empty()) break;
                    ++((PathElement)stack.peek()).index;
                    ((PathElement)stack.peek()).closed = true;
                    ++valIdx;
                }
            }
        }
        StringBuilder path = new StringBuilder("$");
        for (PathElement elm : stack) {
            if (elm.token == JsonToken.BEGIN_ARRAY && elm.index >= 0) {
                path.append("[").append(elm.index).append("]");
            }
            if (elm.token != JsonToken.BEGIN_OBJECT) continue;
            path.append(".");
            if (elm.name == null) continue;
            path.append(elm.name);
        }
        return path.toString();
    }

    public void skipValueAndLookaheadProperty(String propertyName, PropertyConsumer consumer) throws IOException {
        this.beginLookahead();
        this.skipValue();
        while (this.hasNext()) {
            if (StringUtils.equals((CharSequence)this.nextName(), (CharSequence)propertyName)) {
                consumer.consume();
                break;
            }
            this.skipValue();
        }
        this.endLookahead();
    }

    private void promoteNameToValue() throws IOException {
        if (this.tokenPtr != -1) {
            return;
        }
        JsonReaderInternalAccess.INSTANCE.promoteNameToValue(this.backingReader);
    }

    static {
        final JsonReaderInternalAccess previous = (JsonReaderInternalAccess)Preconditions.checkNotNull((Object)JsonReaderInternalAccess.INSTANCE);
        JsonReaderInternalAccess.INSTANCE = new JsonReaderInternalAccess(){

            public void promoteNameToValue(JsonReader jsonReader) throws IOException {
                if (jsonReader instanceof RichJsonReader) {
                    ((RichJsonReader)jsonReader).promoteNameToValue();
                } else {
                    previous.promoteNameToValue(jsonReader);
                }
            }
        };
        logger = Logger.getLogger((String)"dip.poly.reader");
    }

    private static class LookaheadContext {
        LookaheadContext parent;
        int prevTokenPtr;
        int prevStringPtr;

        private LookaheadContext() {
        }
    }

    private static class PathElement {
        JsonToken token;
        int index;
        String name;
        boolean closed;

        private PathElement() {
        }
    }

    public static interface PropertyConsumer {
        public void consume() throws IOException;
    }
}

