/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.Date;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.XArray;

public abstract class ClassChanger<S extends Comparable<S>, T extends Number> {
    private static final Class<? extends Number>[] TYPES_BY_SIZE = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class};
    private static ClassChanger<?, ?>[] changers = new ClassChanger[]{new ClassChanger<Date, Long>(Date.class, Long.class){

        @Override
        protected Long convert(Date object) {
            return object.getTime();
        }

        @Override
        protected Date inverseConvert(Long value) {
            return new Date(value);
        }
    }};
    private final Class<S> source;
    private final Class<T> target;

    protected ClassChanger(Class<S> source, Class<T> target) {
        this.source = source;
        this.target = target;
        if (!Comparable.class.isAssignableFrom(source)) {
            throw new IllegalArgumentException(String.valueOf(source));
        }
        if (!Number.class.isAssignableFrom(target)) {
            throw new IllegalArgumentException(String.valueOf(target));
        }
    }

    protected abstract T convert(S var1) throws ClassCastException;

    protected abstract S inverseConvert(T var1);

    public String toString() {
        return "ClassChanger[" + this.source.getName() + "\u00a0\u21e8\u00a0" + this.target.getName() + ']';
    }

    public static synchronized void register(ClassChanger<?, ?> converter) throws IllegalStateException {
        int i;
        for (i = 0; i < changers.length; ++i) {
            if (!ClassChanger.changers[i].source.isAssignableFrom(converter.source)) continue;
            for (int j = i; j < changers.length; ++j) {
                if (!ClassChanger.changers[j].source.equals(converter.source)) continue;
                throw new IllegalStateException(changers[j].toString());
            }
            break;
        }
        changers = XArray.insert(changers, i, 1);
        ClassChanger.changers[i] = converter;
    }

    private static synchronized <S extends Comparable<S>> ClassChanger<S, ?> getClassChanger(Class<S> source) throws ClassNotFoundException {
        for (ClassChanger<?, ?> candidate : changers) {
            if (!candidate.source.isAssignableFrom(source)) continue;
            ClassChanger<?, ?> c = candidate;
            return c;
        }
        throw new ClassNotFoundException(source.getName());
    }

    public static synchronized Class<?> getTransformedClass(Class<?> source) {
        if (source != null) {
            for (ClassChanger<?, ?> changer : changers) {
                if (!changer.source.isAssignableFrom(source)) continue;
                return changer.target;
            }
        }
        return source;
    }

    public static <K> K toNumber(Comparable<K> object) throws ClassNotFoundException {
        if (object != null) {
            if (object instanceof Number) {
                return (K)object;
            }
            ClassChanger<?, ?> changer = ClassChanger.getClassChanger(object.getClass());
            return (K)changer.convert(object);
        }
        return null;
    }

    public static <C extends Comparable> C toComparable(Number value, Class<C> classe) throws ClassNotFoundException {
        if (value != null) {
            if (Number.class.isAssignableFrom(classe)) {
                return (C)((Comparable)classe.cast(value));
            }
            ClassChanger<C, ?> changer = ClassChanger.getClassChanger(classe);
            C c = changer.inverseConvert(value);
            return (C)((Comparable)classe.cast(c));
        }
        return null;
    }

    public static Class<?> toPrimitive(Class<?> c) throws IllegalArgumentException {
        if (Double.class.equals(c)) {
            return Double.TYPE;
        }
        if (Float.class.equals(c)) {
            return Float.TYPE;
        }
        if (Long.class.equals(c)) {
            return Long.TYPE;
        }
        if (Integer.class.equals(c)) {
            return Integer.TYPE;
        }
        if (Short.class.equals(c)) {
            return Short.TYPE;
        }
        if (Byte.class.equals(c)) {
            return Byte.TYPE;
        }
        if (Boolean.class.equals(c)) {
            return Boolean.TYPE;
        }
        if (Character.class.equals(c)) {
            return Character.TYPE;
        }
        throw ClassChanger.unknownType(c);
    }

    public static Class<?> toWrapper(Class<?> c) throws IllegalArgumentException {
        if (Double.TYPE.equals(c)) {
            return Double.class;
        }
        if (Float.TYPE.equals(c)) {
            return Float.class;
        }
        if (Long.TYPE.equals(c)) {
            return Long.class;
        }
        if (Integer.TYPE.equals(c)) {
            return Integer.class;
        }
        if (Short.TYPE.equals(c)) {
            return Short.class;
        }
        if (Byte.TYPE.equals(c)) {
            return Byte.class;
        }
        if (Boolean.TYPE.equals(c)) {
            return Boolean.class;
        }
        if (Character.TYPE.equals(c)) {
            return Character.class;
        }
        throw ClassChanger.unknownType(c);
    }

    public static <N extends Number> N cast(Number n, Class<N> c) throws IllegalArgumentException {
        if (n == null || n.getClass().equals(c)) {
            return (N)n;
        }
        if (Byte.class.equals(c)) {
            return (N)Byte.valueOf(n.byteValue());
        }
        if (Short.class.equals(c)) {
            return (N)Short.valueOf(n.shortValue());
        }
        if (Integer.class.equals(c)) {
            return (N)Integer.valueOf(n.intValue());
        }
        if (Long.class.equals(c)) {
            return (N)Long.valueOf(n.longValue());
        }
        if (Float.class.equals(c)) {
            return (N)Float.valueOf(n.floatValue());
        }
        if (Double.class.equals(c)) {
            return (N)Double.valueOf(n.doubleValue());
        }
        throw ClassChanger.unknownType(c);
    }

    public static Class<? extends Number> getWidestClass(Number n1, Number n2) throws IllegalArgumentException {
        return ClassChanger.getWidestClass(n1 != null ? n1.getClass() : null, n2 != null ? n2.getClass() : null);
    }

    public static Class<? extends Number> getWidestClass(Class<? extends Number> c1, Class<? extends Number> c2) throws IllegalArgumentException {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return TYPES_BY_SIZE[Math.max(ClassChanger.getRank(c1), ClassChanger.getRank(c2))];
    }

    public static Class<? extends Number> getFinestClass(Class<? extends Number> c1, Class<? extends Number> c2) throws IllegalArgumentException {
        if (c1 == null) {
            return c2;
        }
        if (c2 == null) {
            return c1;
        }
        return TYPES_BY_SIZE[Math.min(ClassChanger.getRank(c1), ClassChanger.getRank(c2))];
    }

    public static Class<? extends Number> getFinestClass(double value) {
        float fv;
        long lg = (long)value;
        if (value == (double)lg) {
            if (lg >= -128L && lg <= 127L) {
                return Byte.class;
            }
            if (lg >= -32768L && lg <= 32767L) {
                return Short.class;
            }
            if (lg >= Integer.MIN_VALUE && lg <= Integer.MAX_VALUE) {
                return Integer.class;
            }
            if (lg >= Long.MIN_VALUE && lg <= Long.MAX_VALUE) {
                return Long.class;
            }
        }
        if (value == (double)(fv = (float)value)) {
            return Float.class;
        }
        return Double.class;
    }

    private static int getRank(Class<? extends Number> c) throws IllegalArgumentException {
        for (int i = 0; i < TYPES_BY_SIZE.length; ++i) {
            if (!TYPES_BY_SIZE[i].isAssignableFrom(c)) continue;
            return i;
        }
        throw ClassChanger.unknownType(c);
    }

    private static IllegalArgumentException unknownType(Class<?> type) {
        return new IllegalArgumentException(Errors.format(187, type));
    }
}

