/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.geoip.fastgeo;

import com.dataiku.geoip.uniquedb.Node;

public class RangeTable {
    Node nodeTable;
    Node keyTable;
    int size;

    public RangeTable(Node node) {
        this.size = node.getInteger(0);
        this.keyTable = node.getNode(1);
        this.nodeTable = node.getNode(2);
    }

    private int compare(int[] a, int[] b) {
        for (int i = 0; i < this.size; ++i) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (a[i] <= b[i]) continue;
            return 1;
        }
        return 0;
    }

    public Node lookup(int[] keys) {
        if (this.nodeTable.size() == 0) {
            return null;
        }
        int minIdx = 0;
        int maxIdx = this.nodeTable.size() - 1;
        int[] currentKey = new int[this.size];
        while (minIdx <= maxIdx) {
            int midIdx = minIdx + maxIdx >>> 1;
            for (int i = 0; i < this.size; ++i) {
                currentKey[i] = this.keyTable.getInteger(midIdx * this.size + i);
            }
            int cmp = this.compare(currentKey, keys);
            if (cmp < 0) {
                minIdx = midIdx + 1;
                continue;
            }
            if (cmp > 0) {
                maxIdx = midIdx - 1;
                continue;
            }
            return this.nodeTable.getNode(midIdx);
        }
        if (minIdx > 0) {
            return this.nodeTable.getNode(minIdx - 1);
        }
        return null;
    }
}

