/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage.commit;

import java.util.Objects;
import org.apache.hadoop.fs.FileStatus;

public class Commit {
    private long version;
    private FileStatus fileStatus;
    private long commitTimestamp;

    public Commit(long l, FileStatus fileStatus, long l2) {
        this.version = l;
        this.fileStatus = fileStatus;
        this.commitTimestamp = l2;
    }

    public long getVersion() {
        return this.version;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public long getCommitTimestamp() {
        return this.commitTimestamp;
    }

    public Commit withFileStatus(FileStatus fileStatus) {
        return new Commit(this.version, fileStatus, this.commitTimestamp);
    }

    public Commit withCommitTimestamp(long l) {
        return new Commit(this.version, this.fileStatus, l);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Commit commit = (Commit)object;
        if (this.version != commit.version) {
            return false;
        }
        if (this.commitTimestamp != commit.commitTimestamp) {
            return false;
        }
        return Objects.equals(this.fileStatus, commit.fileStatus);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.fileStatus, this.commitTimestamp);
    }
}

