/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.SmartObjectRef;
import com.dataiku.dip.analysis.coreservices.flow.SavedModelsCRUDService;
import com.dataiku.dip.apideployer.datamodel.actual.AbstractDeploymentLightStatus;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIDockerDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.AbstractAPIServiceDeployment;
import com.dataiku.dip.apideployer.datamodel.config.AbstractDeploymentInfra;
import com.dataiku.dip.apideployer.datamodel.config.StaticAPIDeploymentInfra;
import com.dataiku.dip.apideployer.deployments.APIServiceDeploymentsService;
import com.dataiku.dip.apideployer.infra.AbstractInfrasService;
import com.dataiku.dip.apideployer.infra.ApiNodeInfrasDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.FilesBasedConnectionsDAO;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.eventserver.dssmodel.EventServerSettings;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.filters.RoutingKeyFiltering;
import com.dataiku.dip.filters.TopicsFiltering;
import com.dataiku.dip.lambda.mgmt.LambdaServicesCRUDService;
import com.dataiku.dip.mec.ModelEvaluationStoresCRUDService;
import com.dataiku.dip.nodeclients.APIDeployerClient;
import com.dataiku.dip.nodeclients.APIDeployerClientProxyUser;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.TimeDimension;
import com.dataiku.dip.processors.ConnectionPathTargetProcessorSettings;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardCreatedSummary;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardService;
import com.dataiku.dip.unifiedmonitoring.wizard.MonitoringWizardSettings;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.studioconfig.DeploymentMonitoringConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LambdaMonitoringWizardService {
    public static final String CLOUD_PROD_INFRA_PREFIX = "api_space";
    public static final String CLOUD_PROD_CONNECTION_NAME_FOR_LOGS = "customer-audit-log";
    public static final String CLOUD_PREPROD_INFRA_PREFIX = "pre_prod_api_space";
    public static final String CLOUD_PREPROD_CONNECTION_NAME_FOR_LOGS = "customer-pre-prod-audit-log";
    public static final String CLOUD_PROD_LOGS_DATASET_NAME = "production-apinode-audit-logs";
    public static final String CLOUD_PRE_PROD_LOGS_DATASET_NAME = "pre-production-apinode-audit-logs";
    public static final String CLOUD_LOGS_PATH_WITHIN_CONNECTION = "/apinode-audit-logs/";
    public static final String CLOUD_K8S_CONNECTION_NAME_FOR_LOGS = "customer-api-audit-log";
    public static final String CLOUD_K8S_PROD_LOGS_DATASET_NAME = "production-api-audit-logs";
    public static final String CLOUD_K8S_PRE_PROD_LOGS_DATASET_NAME = "pre-production-api-audit-logs";
    public static final String CLOUD_K8S_LOGS_PATH_WITHIN_CONNECTION = "/api-audit-logs/";
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private APIServiceDeploymentsService deploymentsService;
    @Autowired
    private DatasetSaveService datasetSaveService;
    @Autowired
    private LambdaServicesCRUDService crudService;
    @Autowired
    private ModelEvaluationStoresCRUDService modelEvaluationStoresCRUDService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private SavedModelsCRUDService smcService;
    @Autowired
    private FilesBasedConnectionsDAO filesBasedConnectionsDAO;
    @Autowired
    private MonitoringWizardService monitoringWizardService;
    @Autowired
    private ApiNodeInfrasDAO apiNodeInfrasDAO;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.service");

    public DeploymentMonitoringConfig createMonitoring_NT(String projectKey, String deploymentId, String endpointId, AuthCtx user) throws Exception {
        PartitioningScheme partitioningScheme;
        String customErrorMessage;
        DSSConnection connection;
        LambdaService service;
        AbstractAPIDeploymentInfra infra;
        AbstractAPIServiceDeployment deploymentSettings;
        TransactionContext.assertNoAttachedTransaction();
        ConnectionPathTargetProcessorSettings eventServerSettings = null;
        try (Transaction t = this.transactionService.beginRead();){
            deploymentSettings = this.getDeploymentSettings(deploymentId, user);
            if (deploymentSettings.generationsMapping == null) {
                throw ErrorContext.iae((String)"The deployment does not contain any version.");
            }
            if (!DKUApp.isDataikuCloud()) {
                eventServerSettings = this.getEventServerSettingsUnsafeAutoTXN(deploymentSettings.generationsMapping.auditRoutingKey);
            }
            infra = this.getDeploymentInfraSettings(deploymentSettings.infraId, user);
            service = this.crudService.getMandatoryUnsafe(projectKey, deploymentSettings.publishedServiceId);
            if (service.getDeploymentMonitoringConfig(deploymentId, endpointId) != null) {
                throw new IllegalArgumentException(String.format("A monitoring already exists for deployment (%s, %s)", deploymentId, endpointId));
            }
        }
        if (!(infra instanceof AbstractAPIDockerDeploymentInfra) && !(infra instanceof StaticAPIDeploymentInfra)) {
            throw new IllegalArgumentException("Automated monitoring is not supported for the selected infrastructure.");
        }
        this.performFeedbackLoopChecks(user, eventServerSettings, infra, deploymentSettings);
        AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus deploymentStatus = this.getDeploymentLightStatus(deploymentId, user);
        BundledSMVersion smv = deploymentStatus.getSMVersion(endpointId);
        if (!smv.originalProjectKey.equals(projectKey)) {
            throw new IllegalArgumentException("Automated monitoring is not yet supported for shared saved models.");
        }
        try (Transaction t = this.transactionService.beginRead();){
            SavedModel savedModel = this.smcService.getMandatory(projectKey, smv.originalSavedModelId);
            if (savedModel.isPartitioned()) {
                throw new IllegalArgumentException("Automated monitoring is not supported for partition models.");
            }
        }
        SmartObjectRef smRef = SmartObjectRef.fromResolved((ITaggingService.TaggableType)ITaggingService.TaggableType.SAVED_MODEL, (String)smv.originalProjectKey, (String)smv.id, (String)projectKey);
        AbstractFSDatasetHandler.AbstractFSConfig logsConnectionConfig = new AbstractFSDatasetHandler.AbstractFSConfig();
        AbstractDeploymentInfra.InfraType infraType = infra.getInfraType();
        if (DKUApp.isDataikuCloud()) {
            connection = infraType == AbstractDeploymentInfra.InfraType.K8S ? this.filesBasedConnectionsDAO.getMandatoryConnection(user, CLOUD_K8S_CONNECTION_NAME_FOR_LOGS) : (infra.id.startsWith(CLOUD_PROD_INFRA_PREFIX) ? this.filesBasedConnectionsDAO.getMandatoryConnection(user, CLOUD_PROD_CONNECTION_NAME_FOR_LOGS) : this.filesBasedConnectionsDAO.getMandatoryConnection(user, CLOUD_PREPROD_CONNECTION_NAME_FOR_LOGS));
            logsConnectionConfig.path = infraType == AbstractDeploymentInfra.InfraType.K8S ? CLOUD_K8S_LOGS_PATH_WITHIN_CONNECTION : CLOUD_LOGS_PATH_WITHIN_CONNECTION;
            customErrorMessage = "No inferences have been made to this deployment yet. At least one inference is required to create the dataset.";
            partitioningScheme = PartitioningScheme.createTimePartitioningScheme((TimeDimension.Period)TimeDimension.Period.DAY);
        } else {
            connection = this.filesBasedConnectionsDAO.getMandatoryConnection(user, eventServerSettings.fileLikeConnectionName);
            logsConnectionConfig.path = StringUtils.defaultString((String)eventServerSettings.fileLikePathWithinConnection) + "/apinode-query/" + StringUtils.defaultString((String)deploymentSettings.generationsMapping.auditRoutingKey);
            customErrorMessage = String.format("No inferences have been made to this deployment yet. At least one inference is required to create the dataset. Your Event server is configured to persist inference data every %s seconds, you need to wait until this happens to be able to setup the monitoring", eventServerSettings.flushEveryS);
            partitioningScheme = PartitioningScheme.createTimePartitioningScheme((TimeDimension.Period)eventServerSettings.partitioningPeriod);
        }
        logsConnectionConfig.connection = connection.name;
        MonitoringWizardSettings.FlowObjectsCreationRequestParams flowObjectsCreationRequestParams = new MonitoringWizardSettings.FlowObjectsCreationRequestParams();
        try (Transaction t = this.transactionService.beginRead();){
            flowObjectsCreationRequestParams.mesName = this.modelEvaluationStoresCRUDService.transmogrifyName(projectKey, deploymentId + "_" + endpointId + "_mes");
            if (DKUApp.isDataikuCloud()) {
                switch (infra.stage) {
                    case "Production": {
                        if (infraType == AbstractDeploymentInfra.InfraType.K8S) {
                            flowObjectsCreationRequestParams.inputDatasetName = CLOUD_K8S_PROD_LOGS_DATASET_NAME;
                            break;
                        }
                        flowObjectsCreationRequestParams.inputDatasetName = CLOUD_PROD_LOGS_DATASET_NAME;
                        break;
                    }
                    case "Pre Production": {
                        if (infraType == AbstractDeploymentInfra.InfraType.K8S) {
                            flowObjectsCreationRequestParams.inputDatasetName = CLOUD_K8S_PRE_PROD_LOGS_DATASET_NAME;
                            break;
                        }
                        flowObjectsCreationRequestParams.inputDatasetName = CLOUD_PRE_PROD_LOGS_DATASET_NAME;
                        break;
                    }
                    default: {
                        flowObjectsCreationRequestParams.inputDatasetName = this.datasetSaveService.transmogrifyName(projectKey, deploymentId + "_" + endpointId + "_logs");
                        break;
                    }
                }
            } else {
                flowObjectsCreationRequestParams.inputDatasetName = this.datasetSaveService.transmogrifyName(projectKey, deploymentId + "_" + endpointId + "_logs");
            }
        }
        MonitoringWizardCreatedSummary monitoringWizardCreatedSummary = this.monitoringWizardService.createMonitoringElements(user, projectKey, connection, logsConnectionConfig, flowObjectsCreationRequestParams, smRef, partitioningScheme, customErrorMessage, deploymentId);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(user);){
            DeploymentMonitoringConfig deploymentConfig = new DeploymentMonitoringConfig(deploymentId, endpointId, monitoringWizardCreatedSummary.inputDatasetRef.objectId, monitoringWizardCreatedSummary.mesRef.objectId, monitoringWizardCreatedSummary.mesName, monitoringWizardCreatedSummary.recipeRef.objectId);
            logger.info((Object)("Add monitoring for deployment :" + deploymentId));
            service.deploymentMonitoring.add(deploymentConfig);
            this.crudService.save(service);
            t.commit("Monitoring created");
            DeploymentMonitoringConfig deploymentMonitoringConfig = deploymentConfig;
            return deploymentMonitoringConfig;
        }
    }

    private void performFeedbackLoopChecks(AuthCtx user, ConnectionPathTargetProcessorSettings eventServerSettings, AbstractAPIDeploymentInfra infra, AbstractAPIServiceDeployment deployment) {
        if (DKUApp.isDataikuCloud()) {
            this.validateCloudConnectionAccessible(user, infra);
            return;
        }
        if (!deployment.getNodeLogging((AbstractAPIDeploymentInfra)infra).automaticallyConfigureEventServerReporting) {
            String excMessage = String.format("Auditing & queries logging is not configured for the deployment '%s' on the API infrastructure '%s'. It must be enabled, using a DSS Event Server, to configure the monitoring automatically.", deployment.id, infra.id);
            throw new IllegalArgumentException(excMessage);
        }
        if (!eventServerSettings.folderByRoutingKey || !eventServerSettings.folderByTopic) {
            throw new IllegalArgumentException("The event-server must enable the subfolder by routing key and subfolder by topic. This must be configured by the administrator.");
        }
    }

    private void validateCloudConnectionAccessible(AuthCtx user, AbstractAPIDeploymentInfra infra) {
        String connectionName = LambdaMonitoringWizardService.getLogsConnectionName(infra);
        try {
            this.filesBasedConnectionsDAO.getMandatoryConnection(user, connectionName);
        }
        catch (Exception e) {
            String excMessage = String.format("The connection '%s' to retrieve the logs is not accessible. Please contact your administrator", connectionName);
            throw new IllegalArgumentException(excMessage, e);
        }
    }

    @Nonnull
    private static String getLogsConnectionName(AbstractAPIDeploymentInfra infra) {
        if (infra.getInfraType() == AbstractDeploymentInfra.InfraType.K8S) {
            return CLOUD_K8S_CONNECTION_NAME_FOR_LOGS;
        }
        if (infra.id.startsWith(CLOUD_PROD_INFRA_PREFIX)) {
            return CLOUD_PROD_CONNECTION_NAME_FOR_LOGS;
        }
        if (infra.id.startsWith(CLOUD_PREPROD_INFRA_PREFIX)) {
            return CLOUD_PREPROD_CONNECTION_NAME_FOR_LOGS;
        }
        throw new IllegalArgumentException("The infrastructure of this deployment is not supported for automated monitoring.");
    }

    private ConnectionPathTargetProcessorSettings getEventServerSettingsUnsafeAutoTXN(String routingKey) throws IOException {
        EventServerSettings ess = this.generalSettingsDAO.getUnsafeAutoTXN().eventServerSettings;
        return ess.targets.stream().filter(target -> !(!target.topicsFiltering.equals((Object)TopicsFiltering.ALL) && !target.topics.contains("apinode-query") || !target.routingKeysFiltering.equals((Object)RoutingKeyFiltering.ALL) && !target.routingKeys.contains(routingKey))).findFirst().orElseThrow(() -> new IllegalArgumentException("The event server does not have any targets that contains the apinode-query topic and your API service routing key. This must be configured by the administrator."));
    }

    public void deleteDeploymentMonitoringMandatoryUnsafe(String projectKey, String deploymentId, String endpointId, boolean deleteObjects, AuthCtx user) throws Exception {
        AbstractAPIServiceDeployment deployment = this.getDeploymentSettings(deploymentId, user);
        LambdaService service = this.crudService.getMandatoryUnsafe(projectKey, deployment.publishedServiceId);
        DeploymentMonitoringConfig monitoringConfig = service.getDeploymentMonitoringConfig(deploymentId, endpointId);
        if (service.getDeploymentMonitoringConfig(deploymentId, endpointId) == null) {
            throw new IllegalArgumentException("No monitoring exists for deployment " + deploymentId);
        }
        if (deleteObjects) {
            if (!this.isDatasetUsedInAnotherMonitoring(service, monitoringConfig.datasetName, deploymentId, endpointId)) {
                try {
                    this.datasetSaveService.delete(projectKey, monitoringConfig.datasetName);
                }
                catch (NotFoundException | FileNotFoundException e) {
                    logger.error((Object)String.format("Dataset %s:%s was not found during deletion, proceeding", projectKey, monitoringConfig.datasetName));
                }
            }
            this.modelEvaluationStoresCRUDService.performDeletion(user, projectKey, monitoringConfig.mesId, null);
        }
        service.deploymentMonitoring.remove(monitoringConfig);
        this.crudService.save(service);
    }

    public DeploymentMonitoringConfig getDeploymentMonitoringMandatoryUnsafe(String projectKey, String deploymentId, String endpointId, AuthCtx user) throws Exception {
        AbstractAPIServiceDeployment deployment = this.getDeploymentSettings(deploymentId, user);
        LambdaService service = this.crudService.getMandatoryUnsafe(projectKey, deployment.publishedServiceId);
        DeploymentMonitoringConfig deploymentMonitoringConfig = service.getDeploymentMonitoringConfig(deploymentId, endpointId);
        if (deploymentMonitoringConfig == null) {
            return new DeploymentMonitoringConfig(deploymentId, endpointId);
        }
        return deploymentMonitoringConfig;
    }

    private boolean isDatasetUsedInAnotherMonitoring(LambdaService service, String datasetName, String deploymentId, String endpointId) {
        for (DeploymentMonitoringConfig config : service.getDeploymentMonitoringConfigs(deploymentId)) {
            if (config.endpointId.equals(endpointId) || !config.datasetName.equals(datasetName)) continue;
            return true;
        }
        return false;
    }

    private AbstractAPIServiceDeployment getDeploymentSettings(String deploymentId, AuthCtx user) throws Exception {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return (AbstractAPIServiceDeployment)this.deploymentsService.getSettingsMandatoryUnsafe_Check(deploymentId, user);
            }
            case REMOTE: {
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    AbstractAPIServiceDeployment abstractAPIServiceDeployment = (AbstractAPIServiceDeployment)client.getDeploymentSettings(deploymentId);
                    return abstractAPIServiceDeployment;
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)ref.mode, (Object[])new Object[0]);
    }

    private AbstractAPIDeploymentInfra getDeploymentInfraSettings(String infraId, AuthCtx user) throws Exception {
        String cannotReadInfraErrorMessage = String.format("You don't have read access to the infrastructure %s", infraId);
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                AbstractAPIDeploymentInfra apiDeploymentInfra = (AbstractAPIDeploymentInfra)this.apiNodeInfrasDAO.getMandatoryUnsafe(infraId);
                if (!AbstractInfrasService.hasReadPermission((AbstractDeploymentInfra)apiDeploymentInfra, (AuthCtx)user)) {
                    throw new IllegalArgumentException(cannotReadInfraErrorMessage);
                }
                return apiDeploymentInfra;
            }
            case REMOTE: {
                boolean canReadInfrastructure;
                try (APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);){
                    canReadInfrastructure = client.checkInfraReadAccessPermission(infraId);
                }
                if (!canReadInfrastructure) {
                    throw new IllegalArgumentException(cannotReadInfraErrorMessage);
                }
                client = new APIDeployerClient(ref);
                try {
                    AbstractAPIDeploymentInfra abstractAPIDeploymentInfra = (AbstractAPIDeploymentInfra)client.getDeploymentInfraSettings(infraId);
                    return abstractAPIDeploymentInfra;
                }
                finally {
                    client.close();
                }
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)ref.mode, (Object[])new Object[0]);
    }

    private AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus getDeploymentLightStatus(String deploymentId, AuthCtx user) throws UnauthorizedException, IOException {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        gs.deployerClientSettings.check();
        GeneralSettingsDAO.DeployerRef ref = gs.deployerClientSettings.getRef();
        switch (ref.mode) {
            case DISABLED: {
                throw ErrorContext.iae((String)"Deployer support is disabled");
            }
            case LOCAL: {
                return (AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus)this.deploymentsService.getLightStatusMandatoryUnsafe_NT_Check(deploymentId, user);
            }
            case REMOTE: {
                AbstractDeploymentLightStatus.APIServiceDeploymentLightStatus aPIServiceDeploymentLightStatus;
                APIDeployerClientProxyUser client = new APIDeployerClientProxyUser(ref, user);
                try {
                    aPIServiceDeploymentLightStatus = client.getDeploymentLightStatus(deploymentId);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                client.close();
                return aPIServiceDeploymentLightStatus;
            }
        }
        throw ErrorContext.iaef((String)"Invalid mode for Deployer: %s", (Object)ref.mode, (Object[])new Object[0]);
    }
}

