/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.coremodel.AppManifest;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.projects.apps.AppsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKULogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.server.ResponseStatusException;

@Controller
@RequestMapping(value={"/publicapi/apps"})
public class PublicAPIAppsController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private AppsService appsService;
    @Autowired
    private TransactionService transactionService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.api.apps");

    @AuditedCall(value={"msgType", "apps-list"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AppsService.AppListItem> list(HttpServletRequest req, @RequestParam(value="tags", required=false) String[] tagList) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            AppsService.AppsList apps = this.appsService.listAppTemplates_T(authCtx);
            if (tagList != null && tagList.length > 0) {
                List unfiltered = apps.items;
                ArrayList filtered = Lists.newArrayList();
                HashSet tagSet = Sets.newHashSet((Object[])tagList);
                for (AppsService.AppListItem p : unfiltered) {
                    if (Sets.intersection((Set)Sets.newHashSet((Iterable)p.tags), (Set)tagSet).isEmpty()) continue;
                    filtered.add(p);
                }
                apps.items = filtered;
            }
            List list = apps.items;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "app-get", "appId", "${appId}"})
    @RequestMapping(value={"/{appId}/"}, method={RequestMethod.GET})
    @ResponseBody
    public AppManifest getManifest(HttpServletRequest req, HttpServletResponse resp, @PathVariable String appId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
            AppManifest appManifest = this.appsService.getAppTemplateManifest_T(appId);
            return appManifest;
        }
    }

    @AuditedCall(value={"msgType", "app-get", "appId", "${appId}"})
    @RequestMapping(value={"/{appId}/instances"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectsService.HomepageProjectItem> getInstances(HttpServletRequest req, HttpServletResponse resp, @PathVariable String appId) throws Exception {
        AuthCtx authCtx;
        ArrayList instances = Lists.newArrayList();
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            ArrayList projects = Lists.newArrayList();
            if (StringUtils.equals((String)"__ORPHANS__", (String)appId)) {
                HashSet existingAppIds = Sets.newHashSet((Iterable)this.appsService.listAppIds_T());
                for (SerializedProject p : this.projectsService.listAllUnsafe()) {
                    if (p.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE || !StringUtils.isNotBlank((String)p.generatingAppId) || existingAppIds.contains(p.generatingAppId)) continue;
                    projects.add(p);
                }
            } else {
                this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
                for (SerializedProject p : this.projectsService.listAllUnsafe()) {
                    if (p.projectAppType != SerializedProject.ProjectAppType.APP_INSTANCE || !StringUtils.equals((String)appId, (String)p.generatingAppId)) continue;
                    projects.add(p);
                }
            }
            for (SerializedProject p : projects) {
                ProjectsService.HomepageProjectItem hpi = this.projectsService.getProjectItemWithReadPermissionCheckFromProject(authCtx, p, true, true);
                if (hpi == null) continue;
                instances.add(hpi);
            }
        }
        for (ProjectsService.HomepageProjectItem hpi : instances) {
            this.projectsService.enrichHomepageProjectItem_NT(hpi, authCtx, true, false, new HashMap());
        }
        return instances;
    }

    @AuditedCall(value={"msgType", "app-create-instance", "appId", "${appId}"})
    @RequestMapping(value={"/{appId}/instances"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AppsService.AppInstantiationResult> createInstance(HttpServletRequest req, HttpServletResponse resp, @PathVariable String appId) throws Exception {
        AppsService.AppInstantiationRequest request = (AppsService.AppInstantiationRequest)this.getRequestBodyAs(req, AppsService.AppInstantiationRequest.class);
        AuthCtx authCtx = null;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.appsService.checkAppInstantiatePerm_T(authCtx, appId);
        }
        AppsService.AppInstantiationParams appInstantiationParams = new AppsService.AppInstantiationParams(Optional.ofNullable(request.targetProjectKey).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "targetProjectKey is mandatory")), request.targetProjectName, null, request.appInstanceCreatorFullId, Optional.ofNullable(request.variables).orElse(new JsonObject()), request.isTemporaryAppInstance);
        return this.appsService.startInstantiate_NT(authCtx, appId, appInstantiationParams, false, false);
    }
}

