/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.Timer;
import com.codahale.metrics.json.MetricsModule;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.maintainance.InstanceInfoService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.exporter.common.TextFormat;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIMetricsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private InstanceInfoService instanceInfoService;

    @AuditedCall(value={"msgType", "internal-metrics-list"})
    @RequestMapping(value={"/publicapi/internal-metrics"}, method={RequestMethod.GET})
    public void showMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="") String name, @RequestParam(defaultValue="") String prefix, @RequestParam(defaultValue="") String type) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        ObjectMapper om = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, false, (MetricFilter)new MetricNameFilter(name, prefix, type)));
        om.writerWithDefaultPrettyPrinter().writeValue((OutputStream)resp.getOutputStream(), (Object)DSSMetrics.registry());
    }

    @AuditedCall(value={"msgType", "instance-info-get"})
    @RequestMapping(value={"/publicapi/instance-info"})
    @ResponseBody
    public InstanceInfoService.InstanceInfo getInstanceInfo(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        boolean isAdmin = false;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            isAdmin = authCtx.isAdmin();
        }
        return this.instanceInfoService.get(isAdmin);
    }

    @AuditedCall(value={"msgType", "metrics-prometheus-get"})
    @RequestMapping(value={"/publicapi/metrics-prometheus"})
    public void getMetricsForPrometheus(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="") String name) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        CollectorRegistry collector = new CollectorRegistry();
        collector.register((Collector)new DropwizardExports(DSSMetrics.registry()));
        Pattern pattern = Pattern.compile(name);
        Enumeration samples = collector.metricFamilySamples();
        ArrayList<Collector.MetricFamilySamples> filteredSamples = new ArrayList<Collector.MetricFamilySamples>();
        while (samples.hasMoreElements()) {
            Collector.MetricFamilySamples sample = (Collector.MetricFamilySamples)samples.nextElement();
            if (!name.isEmpty() && !this.matchesPattern(sample, pattern)) continue;
            filteredSamples.add(sample);
        }
        resp.setStatus(200);
        resp.setContentType("text/plain; version=0.0.4; charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)resp.getOutputStream());){
            TextFormat.write004((Writer)writer, Collections.enumeration(filteredSamples));
            ((Writer)writer).flush();
        }
    }

    private boolean matchesPattern(Collector.MetricFamilySamples sample, Pattern pattern) {
        for (Collector.MetricFamilySamples.Sample s : sample.samples) {
            Matcher matcher = pattern.matcher(s.name);
            if (!matcher.find()) continue;
            return true;
        }
        return false;
    }

    private static class MetricNameFilter
    implements MetricFilter {
        private final String name;
        private final String prefix;
        private final Class<? extends Metric> metricType;

        private MetricNameFilter(String name, String prefix, String metricType) {
            this.name = name;
            this.prefix = prefix;
            switch (metricType.toUpperCase()) {
                case "GAUGES": {
                    this.metricType = Gauge.class;
                    break;
                }
                case "COUNTERS": {
                    this.metricType = Counter.class;
                    break;
                }
                case "HISTOGRAMS": {
                    this.metricType = Histogram.class;
                    break;
                }
                case "METERS": {
                    this.metricType = Meter.class;
                    break;
                }
                case "TIMERS": {
                    this.metricType = Timer.class;
                    break;
                }
                default: {
                    this.metricType = Metric.class;
                }
            }
        }

        public boolean matches(String name, Metric metric) {
            return !(!this.metricType.isInstance(metric) || !this.name.isEmpty() && !name.equals(this.name) || !this.prefix.isEmpty() && !name.startsWith(this.prefix));
        }
    }
}

