/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.openai;

import com.dataiku.dip.utils.GsonNullableJsonElementTypeAdapterFactory;
import com.dataiku.dip.utils.polyjson.Mapping;
import com.dataiku.dip.utils.polyjson.PolyJSON;
import com.dataiku.dss.shadelib.com.google.common.reflect.TypeToken;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class OpenAIChatCompletionRequest {
    public String model;
    public List<OpenAIChatCompletionRequestMessage> messages;
    @Nullable
    @SerializedName(value="frequency_penalty")
    public Double frequencyPenalty;
    @Nullable
    @SerializedName(value="logit_bias")
    public Map<Integer, Double> logitBias;
    @Nullable
    public Boolean logprobs;
    @Nullable
    @SerializedName(value="top_logprobs")
    public Integer topLogprobs;
    @Nullable
    @SerializedName(value="max_tokens")
    public Integer maxTokens;
    @Nullable
    @SerializedName(value="presence_penalty")
    public Double presencePenalty;
    @Nullable
    public List<String> stop;
    @Nullable
    public Double temperature;
    @Nullable
    @SerializedName(value="top_p")
    public Double topP;
    @Nullable
    @SerializedName(value="response_format")
    public OpenAIChatCompletionRequestFormat responseFormat;
    @Nullable
    public List<OpenAIChatCompletionRequestAbstractTool> tools;
    @Nullable
    @SerializedName(value="tool_choice")
    @JsonAdapter(value=OpenAIChatCompletionRequestToolChoiceDeserializer.class)
    public OpenAIChatCompletionRequestToolChoice toolChoice;
    @Nullable
    public Boolean stream;
    @Nullable
    public OpenAIChatCompletionRequestStreamOptions stream_options;
    @Nullable
    public Integer n;

    public static class OpenAIChatCompletionRequestStreamOptions {
        @Nullable
        public Boolean include_usage;
    }

    public static class OpenAIChatCompletionRequestFunctionToolCallInfo {
        public String name;
        public String arguments;
    }

    public static class OpenAIChatCompletionRequestFunctionToolCall
    extends OpenAIChatCompletionRequestToolCall {
        public OpenAIChatCompletionRequestFunctionToolCallInfo function;
    }

    @PolyJSON(value={@Mapping(value=OpenAIChatCompletionRequestFunctionToolCall.class, type="function")})
    public static abstract class OpenAIChatCompletionRequestToolCall {
        public String id;
    }

    public static class ImageUrl {
        public String url;
    }

    public static class OpenAIChatCompletionMessageContentPart {
        public String type;
        @Nullable
        public String text;
        @SerializedName(value="image_url")
        @Nullable
        public ImageUrl imageUrl;
    }

    public static class OpenAIChatCompletionRequestMessageContent {
        public String text;
        public List<OpenAIChatCompletionMessageContentPart> parts;
    }

    public static class OpenAIChatCompletionRequestMessageContentDeserializer
    implements JsonDeserializer<OpenAIChatCompletionRequestMessageContent> {
        public OpenAIChatCompletionRequestMessageContent deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            OpenAIChatCompletionRequestMessageContent content = new OpenAIChatCompletionRequestMessageContent();
            if (jsonElement.isJsonArray()) {
                content.parts = (List)jsonDeserializationContext.deserialize(jsonElement, new TypeToken<List<OpenAIChatCompletionMessageContentPart>>(){}.getType());
            } else {
                content.text = jsonElement.getAsString();
            }
            return content;
        }
    }

    public static class OpenAIChatCompletionRequestAssistantMessage
    extends OpenAIChatCompletionRequestMessage {
        @Nullable
        @JsonAdapter(value=OpenAIChatCompletionRequestMessageContentDeserializer.class)
        public OpenAIChatCompletionRequestMessageContent content;
        @SerializedName(value="tool_calls")
        @Nullable
        public List<OpenAIChatCompletionRequestToolCall> toolCalls;
    }

    public static class OpenAIChatCompletionRequestToolMessage
    extends OpenAIChatCompletionRequestMessage {
        @JsonAdapter(value=OpenAIChatCompletionRequestMessageContentDeserializer.class)
        public OpenAIChatCompletionRequestMessageContent content;
        @SerializedName(value="tool_call_id")
        public String toolCallId;
    }

    public static class OpenAIChatCompletionRequestSystemMessage
    extends OpenAIChatCompletionRequestMessage {
        @JsonAdapter(value=OpenAIChatCompletionRequestMessageContentDeserializer.class)
        public OpenAIChatCompletionRequestMessageContent content;
    }

    public static class OpenAIChatCompletionRequestUserMessage
    extends OpenAIChatCompletionRequestMessage {
        @JsonAdapter(value=OpenAIChatCompletionRequestMessageContentDeserializer.class)
        public OpenAIChatCompletionRequestMessageContent content;
    }

    @PolyJSON(typeProperty="role", value={@Mapping(value=OpenAIChatCompletionRequestUserMessage.class, type="user"), @Mapping(value=OpenAIChatCompletionRequestSystemMessage.class, type="system"), @Mapping(value=OpenAIChatCompletionRequestToolMessage.class, type="tool"), @Mapping(value=OpenAIChatCompletionRequestAssistantMessage.class, type="assistant")})
    public static abstract class OpenAIChatCompletionRequestMessage {
    }

    public static class OpenAIChatCompletionRequestFormatJsonSchema
    extends OpenAIChatCompletionRequestFormat {
        @SerializedName(value="json_schema")
        public SchemaData jsonSchema = new SchemaData();

        public static class SchemaData {
            @Nullable
            public String description;
            public String name;
            public JsonObject schema;
            @Nullable
            public Boolean strict;
        }
    }

    public static class OpenAIChatCompletionRequestFormatJsonObject
    extends OpenAIChatCompletionRequestFormat {
    }

    public static class OpenAIChatCompletionRequestFormatText
    extends OpenAIChatCompletionRequestFormat {
    }

    @PolyJSON(value={@Mapping(type="text", value=OpenAIChatCompletionRequestFormatText.class), @Mapping(type="json_object", value=OpenAIChatCompletionRequestFormatJsonObject.class), @Mapping(type="json_schema", value=OpenAIChatCompletionRequestFormatJsonSchema.class)})
    public static abstract class OpenAIChatCompletionRequestFormat {
    }

    public static class OpenAIChatCompletionRequestFunctionToolDesc {
        public String name;
        @Nullable
        public String description;
        @Nullable
        @JsonAdapter(value=GsonNullableJsonElementTypeAdapterFactory.class)
        public JsonObject parameters;
    }

    public static class OpenAIChatCompletionRequestFunctionTool
    extends OpenAIChatCompletionRequestAbstractTool {
        public OpenAIChatCompletionRequestFunctionToolDesc function;
    }

    @PolyJSON(value={@Mapping(value=OpenAIChatCompletionRequestFunctionTool.class, type="function")})
    public static abstract class OpenAIChatCompletionRequestAbstractTool {
    }

    public static class OpenAIChatCompletionRequestFunctionToolChoiceDesc {
        public String name;
    }

    public static class OpenAIChatCompletionRequestFunctionToolChoice
    extends OpenAIChatCompletionRequestObjectToolChoice {
        public OpenAIChatCompletionRequestFunctionToolChoiceDesc function;
    }

    @PolyJSON(value={@Mapping(value=OpenAIChatCompletionRequestFunctionToolChoice.class, type="function")})
    public static abstract class OpenAIChatCompletionRequestObjectToolChoice
    extends OpenAIChatCompletionRequestToolChoice {
    }

    public static class OpenAIChatCompletionRequestRequiredToolChoice
    extends OpenAIChatCompletionRequestToolChoice {
    }

    public static class OpenAIChatCompletionRequestNoneToolChoice
    extends OpenAIChatCompletionRequestToolChoice {
    }

    public static class OpenAIChatCompletionRequestAutoToolChoice
    extends OpenAIChatCompletionRequestToolChoice {
    }

    public static abstract class OpenAIChatCompletionRequestToolChoice {
    }

    public static class OpenAIChatCompletionRequestToolChoiceDeserializer
    implements JsonDeserializer<OpenAIChatCompletionRequestToolChoice> {
        public OpenAIChatCompletionRequestToolChoice deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            String toolChoiceMode;
            if (jsonElement.isJsonObject()) {
                return (OpenAIChatCompletionRequestToolChoice)jsonDeserializationContext.deserialize(jsonElement, OpenAIChatCompletionRequestObjectToolChoice.class);
            }
            switch (toolChoiceMode = jsonElement.getAsString()) {
                case "auto": {
                    return new OpenAIChatCompletionRequestAutoToolChoice();
                }
                case "required": {
                    return new OpenAIChatCompletionRequestRequiredToolChoice();
                }
                case "none": {
                    return new OpenAIChatCompletionRequestNoneToolChoice();
                }
            }
            throw new JsonParseException("Unknown tool choice: " + toolChoiceMode);
        }
    }
}

