/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.docportal;

import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.docportal.PythonDocPortalService;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.notifications.DSSEventListener;
import com.dataiku.dip.server.services.IndexableType;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.AbstractSearchService;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneResponseWrapper;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dip.server.services.catalog.docportal.PythonDocPortalIndexingQueueHandler;
import com.dataiku.dss.shadelib.org.apache.lucene.index.Term;
import com.dataiku.dss.shadelib.org.apache.lucene.queryparser.classic.ParseException;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Collector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TermQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopScoreDocCollector;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TopScoreDocCollectorManager;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PythonDocPortalSearchService
extends AbstractSearchService {
    @Autowired
    private PythonDocPortalIndexingQueueHandler queueHandler;
    @Autowired
    @Qualifier(value="pythonDocPortalMappingsAnalyzer")
    private LuceneMappingsAnalyzer pythonDocPortalMappingsAnalyzer;
    @Autowired
    @Qualifier(value="pythonDocPortalIndexManager")
    private LuceneIndexManager pythonDocPortalIndexManager;

    @Override
    public AbstractIndexingQueueHandler getQueueHandler() {
        return this.queueHandler;
    }

    @Override
    @PostConstruct
    public void subscribeEvents() {
        this.pubSub.subscribe("docportal-documentation-generated", (DSSEventListener)this);
    }

    @Override
    protected Query accessFilter(AuthCtx user) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LuceneResponseWrapper search(String queryString, AuthCtx user, Options options, List<String> accessibleProjects) throws IOException, ParseException, DKUSecurityException {
        LuceneResponseWrapper result = new LuceneResponseWrapper();
        TopScoreDocCollector topDocsCollector = new TopScoreDocCollectorManager(options.maxSize, options.maxSize).newCollector();
        BooleanQuery.Builder rootBooleanQueryBuilder = new BooleanQuery.Builder();
        if (!user.isAdmin()) {
            rootBooleanQueryBuilder.add(PythonDocPortalSearchService.getSecurityQuery(accessibleProjects), BooleanClause.Occur.FILTER);
        }
        HashMap<String, Float> boosts = new HashMap<String, Float>();
        boosts.put("name", Float.valueOf(3.0f));
        boosts.put("docstring", Float.valueOf(2.0f));
        boosts.put("arguments", Float.valueOf(1.5f));
        boosts.put("packageName", Float.valueOf(1.0f));
        boosts.put("importPath", Float.valueOf(1.0f));
        String[] fields = boosts.keySet().toArray(new String[0]);
        Query q = this.buildStringQuery(queryString, fields, boosts, this.pythonDocPortalMappingsAnalyzer.getPerFieldAnalyzerWrapper(PythonDocPortalIndexingQueueHandler.TYPE), this.pythonDocPortalMappingsAnalyzer.getMappingForType(PythonDocPortalIndexingQueueHandler.TYPE));
        rootBooleanQueryBuilder.add(q, BooleanClause.Occur.MUST);
        BooleanQuery rootQuery = rootBooleanQueryBuilder.build();
        IndexSearcher indexSearcher = this.pythonDocPortalIndexManager.acquireIndexSearcher();
        try {
            LuceneSecureIndexReader secureIndexReader = this.pythonDocPortalIndexManager.getSecureIndexReader(indexSearcher);
            try (DSSMetrics.TimeCtx ignored = DSSMetrics.timeCtx((String)"docportal.search.request");){
                indexSearcher.search((Query)rootQuery, (Collector)topDocsCollector);
                this.addHitsInResponse(secureIndexReader, IndexableType.DOC_PORTAL, topDocsCollector.topDocs(), result, this.pythonDocPortalIndexManager);
            }
        }
        finally {
            this.pythonDocPortalIndexManager.releaseIndexSearcher(indexSearcher);
        }
        result.serializeJsonPayloads(this.pythonDocPortalMappingsAnalyzer.getJsons(PythonDocPortalIndexingQueueHandler.TYPE));
        return result;
    }

    private static Query getSecurityQuery(List<String> accessibleProjects) {
        BooleanQuery.Builder accessibleProjectQuery = new BooleanQuery.Builder();
        accessibleProjects.forEach(p -> accessibleProjectQuery.add((Query)new TermQuery(new Term("projectKey", p)), BooleanClause.Occur.SHOULD));
        BooleanQuery.Builder globalOrInternalLibQuery = new BooleanQuery.Builder();
        globalOrInternalLibQuery.add((Query)new TermQuery(new Term("packageScope", PythonDocPortalService.PackageScope.GLOBAL.toString())), BooleanClause.Occur.SHOULD);
        BooleanQuery.Builder securityBooleanQueryBuilder = new BooleanQuery.Builder();
        securityBooleanQueryBuilder.add((Query)accessibleProjectQuery.build(), BooleanClause.Occur.SHOULD);
        securityBooleanQueryBuilder.add((Query)globalOrInternalLibQuery.build(), BooleanClause.Occur.SHOULD);
        return securityBooleanQueryBuilder.build();
    }

    public static class Options {
        private final int maxSize;

        public Options(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

