/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils.j3ts;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.j3ts.PyTranslator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class DSSJ2PyMain {
    public static void main(String[] args) throws Exception {
        File installDir = DSSJ2PyMain.initAndGetInstallDir();
        File outDir = new File(installDir, "src/main/python/generated_sources");
        PyTranslator translator = new PyTranslator();
        if ("INTELLIJ".equals(System.getenv("J2PY_MODE"))) {
            translator.addRootMapping(new File(installDir, "out/production/backend-main-java-r/"), null);
            translator.addRootMapping(new File(installDir, "out/production/dku-core/"), null);
            translator.addRootMapping(new File(installDir, "out/production/app-platform/"), null);
        } else if ("JARS".equals(System.getenv("J2PY_MODE"))) {
            translator.addRootMapping(new File(installDir, "dist/dataiku-dip.jar"), null);
            translator.addRootMapping(new File(installDir, "dist/dataiku-app-platform.jar"), null);
            translator.addRootMapping(new File(installDir, "dist/dataiku-core.jar"), null);
        } else {
            throw new RuntimeException("Please set env J2PY_MODE to INTELLIJ or JARS");
        }
        translator.translateInto(outDir, false);
    }

    public static File initAndGetInstallDir() throws IOException {
        Path dir = Files.createTempDirectory("j2py", new FileAttribute[0]);
        String installDirStr = System.getenv("DKUINSTALLDIR");
        if (installDirStr == null) {
            throw new RuntimeException("DKUINSTALLDIR is not set");
        }
        File installDir = new File(installDirStr).getCanonicalFile();
        if (!new File(installDirStr, "app-platform/src/main/java").isDirectory()) {
            throw new RuntimeException("DKUINSTALLDIR is not set to the root of the DSS git repository");
        }
        DKUApp.configureNoConfig((String)dir.toAbsolutePath().toString(), (String)installDir.toString());
        return installDir;
    }
}

