/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg;

import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonParser;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.core.JsonToken;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.DeserializationContext;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.databind.type.LogicalType;
import com.dataiku.dss.shadelibtd.com.fasterxml.jackson.datatype.jsonorg.JSONArrayDeserializer;
import com.dataiku.dss.shadelibtd.org.json.JSONException;
import com.dataiku.dss.shadelibtd.org.json.JSONObject;
import java.io.IOException;

public class JSONObjectDeserializer
extends StdDeserializer<JSONObject> {
    private static final long serialVersionUID = 1L;
    public static final JSONObjectDeserializer instance = new JSONObjectDeserializer();

    public JSONObjectDeserializer() {
        super(JSONObject.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public JSONObject deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JSONObject ob = new JSONObject();
        JsonToken t2 = p.getCurrentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p.nextToken();
        }
        while (t2 == JsonToken.FIELD_NAME) {
            block15: {
                String fieldName = p.getCurrentName();
                t2 = p.nextToken();
                try {
                    switch (t2) {
                        case START_ARRAY: {
                            ob.put(fieldName, JSONArrayDeserializer.instance.deserialize(p, ctxt));
                            break block15;
                        }
                        case START_OBJECT: {
                            ob.put(fieldName, this.deserialize(p, ctxt));
                            break block15;
                        }
                        case VALUE_STRING: {
                            ob.put(fieldName, p.getText());
                            break block15;
                        }
                        case VALUE_NULL: {
                            ob.put(fieldName, JSONObject.NULL);
                            break block15;
                        }
                        case VALUE_TRUE: {
                            ob.put(fieldName, Boolean.TRUE);
                            break block15;
                        }
                        case VALUE_FALSE: {
                            ob.put(fieldName, Boolean.FALSE);
                            break block15;
                        }
                        case VALUE_NUMBER_INT: {
                            ob.put(fieldName, p.getNumberValue());
                            break block15;
                        }
                        case VALUE_NUMBER_FLOAT: {
                            ob.put(fieldName, p.getDecimalValue());
                            break block15;
                        }
                        case VALUE_EMBEDDED_OBJECT: {
                            ob.put(fieldName, p.getEmbeddedObject());
                            break block15;
                        }
                    }
                }
                catch (JSONException e) {
                    throw ctxt.instantiationException(this.handledType(), e);
                }
                return (JSONObject)ctxt.handleUnexpectedToken(JSONObject.class, p);
            }
            t2 = p.nextToken();
        }
        return ob;
    }
}

