/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc.jdbc42;

import com.databricks.client.dsi.dataengine.interfaces.IResultSet;
import com.databricks.client.dsi.dataengine.utilities.MetadataSourceID;
import com.databricks.client.exceptions.ExceptionConverter;
import com.databricks.client.jdbc.common.SMetaDataProxy;
import com.databricks.client.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.databricks.client.jdbc.jdbc42.S42ResultSetMetaData;
import com.databricks.client.support.ILogger;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.utilities.JDBCVersion;
import java.sql.DatabaseMetaData;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S42MetaDataProxy
extends SMetaDataProxy {
    public S42MetaDataProxy(DatabaseMetaData databaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger) throws SQLException {
        super(databaseMetaData, iResultSet, metadataSourceID, iLogger, JDBCVersion.JDBC42);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (null == this.m_resultMetaData) {
            this.generateMetadataList();
            this.m_resultMetaData = new S42ResultSetMetaData(this.m_resultSetColumns, this.m_logger, this.m_warningListener);
        }
        return this.m_resultMetaData;
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, n, clazz);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.findColumn(string), clazz);
    }
}

