/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl;

import com.databricks.client.jdbc42.internal.apache.arrow.memory.ArrowBuf;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.LargeVarCharVector;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.complex.impl.AbstractFieldWriter;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.LargeVarCharHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.holders.NullableLargeVarCharHolder;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.types.pojo.Field;
import com.databricks.client.jdbc42.internal.apache.arrow.vector.util.Text;

public class LargeVarCharWriterImpl
extends AbstractFieldWriter {
    final LargeVarCharVector vector;
    private final Text textBuffer = new Text();

    public LargeVarCharWriterImpl(LargeVarCharVector vector) {
        this.vector = vector;
    }

    @Override
    public Field getField() {
        return this.vector.getField();
    }

    @Override
    public int getValueCapacity() {
        return this.vector.getValueCapacity();
    }

    @Override
    public void allocate() {
        this.vector.allocateNew();
    }

    @Override
    public void close() {
        this.vector.close();
    }

    @Override
    public void clear() {
        this.vector.clear();
    }

    @Override
    protected int idx() {
        return super.idx();
    }

    @Override
    public void write(LargeVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    public void write(NullableLargeVarCharHolder h) {
        this.vector.setSafe(this.idx(), h);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(long start, long end, ArrowBuf buffer) {
        this.vector.setSafe(this.idx(), 1, start, end, buffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(Text value) {
        this.vector.setSafe(this.idx(), value);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeLargeVarChar(String value) {
        this.textBuffer.set(value);
        this.vector.setSafe(this.idx(), this.textBuffer);
        this.vector.setValueCount(this.idx() + 1);
    }

    @Override
    public void writeNull() {
        this.vector.setNull(this.idx());
        this.vector.setValueCount(this.idx() + 1);
    }
}

