/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.client.spark.jdbc;

import com.databricks.client.dsi.core.impl.DSIDriverSingleton;
import com.databricks.client.hivecommon.api.HS2Client;
import com.databricks.client.hivecommon.api.HiveServer2BaseBuffer;
import com.databricks.client.hivecommon.api.RowsetBuffer;
import com.databricks.client.hivecommon.core.HiveJDBCCommonDriver;
import com.databricks.client.hivecommon.exceptions.HiveJDBCMessageKey;
import com.databricks.client.jdbc42.internal.apache.hive.service.rpc.thrift.TSparkArrowResultLink;
import com.databricks.client.spark.arrow.ArrowBuffer;
import com.databricks.client.spark.jdbc.DownloadableExecutionContext;
import com.databricks.client.spark.jdbc.ResultFileDownloadHandler;
import com.databricks.client.spark.jdbc.ResultFileDownloadMonitor;
import com.databricks.client.support.LogUtilities;
import com.databricks.client.support.exceptions.ErrorException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ResultFileDownloadManager {
    private ThreadPoolExecutor m_threadPool;
    private HashSet<HS2Client> m_registeredClients = new HashSet();
    private static ResultFileDownloadManager s_resultFileDownloadManager = null;

    public void addFileLinks(DownloadableExecutionContext downloadableExecutionContext, List<TSparkArrowResultLink> list) {
        LogUtilities.logFunctionEntrance(downloadableExecutionContext.getLogger(), new Object[0]);
        for (TSparkArrowResultLink tSparkArrowResultLink : list) {
            if (tSparkArrowResultLink.getRowCount() <= 0L) continue;
            downloadableExecutionContext.m_resultFileDownloadHandlers.add(new ResultFileDownloadHandler(downloadableExecutionContext, tSparkArrowResultLink));
        }
    }

    public static synchronized boolean isResultDownloadManagerCreated() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        return null != s_resultFileDownloadManager;
    }

    public boolean getNextDownloadedFile(DownloadableExecutionContext downloadableExecutionContext, RowsetBuffer<HiveServer2BaseBuffer> rowsetBuffer) throws ErrorException {
        LogUtilities.logFunctionEntrance(downloadableExecutionContext.getLogger(), new Object[0]);
        ArrowBuffer arrowBuffer = (ArrowBuffer)rowsetBuffer.getBuffer();
        if (downloadableExecutionContext.m_resultFileDownloadHandlers.isEmpty()) {
            return true;
        }
        for (int i = 0; i < downloadableExecutionContext.m_resultFileDownloadHandlers.size(); ++i) {
            TSparkArrowResultLink object2 = downloadableExecutionContext.m_resultFileDownloadHandlers.get((int)i).m_resultLink;
            if (object2.getStartRowOffset() + object2.getRowCount() >= downloadableExecutionContext.m_driverSideStartRowOffset) continue;
            downloadableExecutionContext.m_resultFileDownloadHandlers.remove(i);
            --i;
        }
        for (ResultFileDownloadHandler resultFileDownloadHandler : downloadableExecutionContext.m_resultFileDownloadHandlers) {
            if (resultFileDownloadHandler.m_isDownloadScheduled) continue;
            if (resultFileDownloadHandler.m_executionContext.m_downloadedResultFilesSize + resultFileDownloadHandler.m_resultLink.getBytesNum() > arrowBuffer.m_settings.m_arrowMaxBytesPerFetch) break;
            try {
                this.m_threadPool.submit(resultFileDownloadHandler);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                LogUtilities.logWarning("The download task has been rejected by the thread pool: " + rejectedExecutionException.getMessage(), downloadableExecutionContext.getLogger());
                break;
            }
            resultFileDownloadHandler.m_isDownloadScheduled = true;
            resultFileDownloadHandler.m_executionContext.m_downloadedResultFilesSize += resultFileDownloadHandler.m_resultLink.getBytesNum();
        }
        for (int i = 0; i < downloadableExecutionContext.m_resultFileDownloadHandlers.size(); ++i) {
            ResultFileDownloadHandler resultFileDownloadHandler = downloadableExecutionContext.m_resultFileDownloadHandlers.get(i);
            if (!resultFileDownloadHandler.m_isDownloadScheduled) continue;
            if (!this.checkAndHandleDownloadError(resultFileDownloadHandler, downloadableExecutionContext)) {
                arrowBuffer.m_resultFile = resultFileDownloadHandler.m_resultFile;
                arrowBuffer.m_totalRowsNeeded = resultFileDownloadHandler.m_resultLink.getRowCount();
                arrowBuffer.initializeBuffer();
                downloadableExecutionContext.m_driverSideStartRowOffset += resultFileDownloadHandler.m_resultLink.getRowCount();
                resultFileDownloadHandler.m_executionContext.m_downloadedResultFilesSize -= resultFileDownloadHandler.m_resultLink.getBytesNum();
                downloadableExecutionContext.m_resultFileDownloadHandlers.remove(i);
                return false;
            }
            downloadableExecutionContext.m_serverHasMoreRows = true;
            return true;
        }
        return true;
    }

    public static synchronized ResultFileDownloadManager getResultFileDownloadManager() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        if (null == s_resultFileDownloadManager) {
            s_resultFileDownloadManager = new ResultFileDownloadManager();
        }
        return s_resultFileDownloadManager;
    }

    public synchronized void registerClient(HS2Client hS2Client) {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        this.m_registeredClients.add(hS2Client);
        if (null == this.m_threadPool || this.m_threadPool.isShutdown()) {
            this.m_threadPool = new ThreadPoolExecutor(hS2Client.m_settings.m_downloadableResultSettings.m_maxDownloadThreads + 1, hS2Client.m_settings.m_downloadableResultSettings.m_maxDownloadThreads + 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            this.m_threadPool.execute(ResultFileDownloadMonitor.getResultFileDownloadMonitor());
        }
    }

    public synchronized void unregisterClient(HS2Client hS2Client) {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
        this.m_registeredClients.remove(hS2Client);
        if (this.m_registeredClients.isEmpty()) {
            ResultFileDownloadMonitor.getResultFileDownloadMonitor().stop();
            this.m_threadPool.shutdown();
            while (!this.m_threadPool.isShutdown()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    LogUtilities.logWarning("Got an InterruptedException while trying to shuteown the thread pool: " + interruptedException.getMessage(), hS2Client.getLogger());
                }
            }
        }
    }

    private ResultFileDownloadManager() {
        LogUtilities.logFunctionEntrance(DSIDriverSingleton.getInstance().getDriverLog(), new Object[0]);
    }

    private boolean checkAndHandleDownloadError(ResultFileDownloadHandler resultFileDownloadHandler, DownloadableExecutionContext downloadableExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(downloadableExecutionContext.getLogger(), new Object[0]);
        if (!resultFileDownloadHandler.isFileDownloadSuccessfully()) {
            Object object;
            for (ResultFileDownloadHandler resultFileDownloadHandler2 : downloadableExecutionContext.m_resultFileDownloadHandlers) {
                ResultFileDownloadMonitor.getResultFileDownloadMonitor().stopDownloadTask(resultFileDownloadHandler2.m_httpRequest);
            }
            downloadableExecutionContext.m_resultFileDownloadHandlers.clear();
            resultFileDownloadHandler.m_executionContext.m_downloadedResultFilesSize = 0L;
            if (resultFileDownloadHandler.m_isLinkExpired || resultFileDownloadHandler.m_isDownloadTimedout || resultFileDownloadHandler.m_executionContext.m_settings.m_downloadableResultSettings.m_retriableHttpCodeForDownloadableResult.IsNumberInIntervals(resultFileDownloadHandler.m_httpCode) || resultFileDownloadHandler.m_executionContext.m_settings.m_downloadableResultSettings.m_isConsiderAllResultFileDownloadErrorsRetriable) {
                LogUtilities.logDebug(String.format("Consecutive ResultFileDownload Retries is %d", downloadableExecutionContext.m_numConsecutiveResultFileDownloadRetries), downloadableExecutionContext.getLogger());
                if (downloadableExecutionContext.m_numConsecutiveResultFileDownloadRetries++ >= downloadableExecutionContext.m_settings.m_downloadableResultSettings.m_maxConsecutiveResultFileDownloadRetries) {
                    object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_DOWNLOAD_EXCEED_MAX_RETRY_LIMIT.name(), new String[]{resultFileDownloadHandler.m_resultLink.getFileLink(), String.valueOf(downloadableExecutionContext.m_settings.m_downloadableResultSettings.m_maxConsecutiveResultFileDownloadRetries), "MaxConsecutiveResultFileDownloadRetries"});
                    throw object;
                }
            } else {
                object = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.FILE_DOWNLOAD_ERROR.name(), new String[]{resultFileDownloadHandler.m_resultLink.getFileLink(), String.valueOf(resultFileDownloadHandler.m_httpCode)});
                throw object;
            }
            downloadableExecutionContext.m_downloadNeedRetry = true;
            return true;
        }
        downloadableExecutionContext.m_numConsecutiveResultFileDownloadRetries = 0;
        downloadableExecutionContext.m_downloadNeedRetry = false;
        return false;
    }
}

