/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.models;

import com.dataiku.scoring.Try;
import com.dataiku.scoring.linalg.Vector;
import com.dataiku.scoring.models.Regressor;
import java.util.Arrays;

public class LinearRegression
implements Regressor {
    private static final long serialVersionUID = 0L;
    private final double intercept;
    private final double[] coefficients;

    public LinearRegression(double intercept, double[] coefficients) {
        this.intercept = intercept;
        this.coefficients = coefficients;
    }

    public double getIntercept() {
        return this.intercept;
    }

    public double[] getCoefficients() {
        return Arrays.copyOf(this.coefficients, this.coefficients.length);
    }

    @Override
    public Try<Double> predict(Vector v) {
        if (v.size() != this.coefficients.length) {
            return Try.failure("Vector length did not match coefficients length");
        }
        double p = this.intercept;
        for (int i : v.activeIndices()) {
            if (i < 0 || i >= this.coefficients.length) {
                return Try.failure("Index out of bounds in coefficients");
            }
            p += this.coefficients[i] * v.get(i);
        }
        return Try.success(p);
    }
}

