/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines;

import com.dataiku.scoring.pipelines.Processor;
import com.dataiku.scoring.util.RawObservation;

public class Flagger
implements Processor {
    private static final long serialVersionUID = 0L;
    private final String[] columns;
    private final String[] outputNames;

    public Flagger(String[] columns, String[] outputNames) {
        this.columns = columns;
        this.outputNames = outputNames;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public String[] getOutputNames() {
        return this.outputNames;
    }

    @Override
    public void process(RawObservation data) {
        for (int i = 0; i < this.columns.length; ++i) {
            String col = this.columns[i];
            Object value = data.get(col);
            if (value == null) continue;
            data.remove(col);
            data.put(this.outputNames[i], 1.0);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append("Flagger(");
        for (int i = 0; i < this.columns.length; ++i) {
            s.append(this.columns[i]);
            if (i == this.columns.length - 1) continue;
            s.append(" ; ");
        }
        return s.append(")").toString();
    }
}

