/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.ingest.internal.apache.http.impl.nio.codecs;

import net.snowflake.ingest.internal.apache.http.HttpRequest;
import net.snowflake.ingest.internal.apache.http.HttpRequestFactory;
import net.snowflake.ingest.internal.apache.http.annotation.Contract;
import net.snowflake.ingest.internal.apache.http.annotation.ThreadingBehavior;
import net.snowflake.ingest.internal.apache.http.config.MessageConstraints;
import net.snowflake.ingest.internal.apache.http.impl.DefaultHttpRequestFactory;
import net.snowflake.ingest.internal.apache.http.impl.nio.codecs.DefaultHttpRequestParser;
import net.snowflake.ingest.internal.apache.http.message.BasicLineParser;
import net.snowflake.ingest.internal.apache.http.message.LineParser;
import net.snowflake.ingest.internal.apache.http.nio.NHttpMessageParser;
import net.snowflake.ingest.internal.apache.http.nio.NHttpMessageParserFactory;
import net.snowflake.ingest.internal.apache.http.nio.reactor.SessionInputBuffer;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpRequestParserFactory
implements NHttpMessageParserFactory<HttpRequest> {
    public static final DefaultHttpRequestParserFactory INSTANCE = new DefaultHttpRequestParserFactory();
    private final LineParser lineParser;
    private final HttpRequestFactory requestFactory;

    public DefaultHttpRequestParserFactory(LineParser lineParser, HttpRequestFactory requestFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.requestFactory = requestFactory != null ? requestFactory : DefaultHttpRequestFactory.INSTANCE;
    }

    public DefaultHttpRequestParserFactory() {
        this(null, null);
    }

    @Override
    public NHttpMessageParser<HttpRequest> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpRequestParser(buffer, this.lineParser, this.requestFactory, constraints);
    }
}

