/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip;

import com.dataiku.dip.security.PasswordEncryptionService;
import java.net.InetSocketAddress;
import java.net.Proxy;
import org.apache.commons.lang.StringUtils;

public class ProxySettings {
    public String host;
    public int port;
    public String username;
    public String password;

    public ProxySettings() {
    }

    public ProxySettings(ProxySettings proxySettings) {
        this.host = proxySettings.host;
        this.port = proxySettings.port;
        this.username = proxySettings.username;
        this.password = proxySettings.password;
    }

    public ProxySettings deepCopy() {
        return new ProxySettings(this);
    }

    public boolean hasProxy() {
        return !StringUtils.isBlank((String)this.host) && this.port > 0 && this.port < 65536;
    }

    public boolean hasAuthentication() {
        return !StringUtils.isBlank((String)this.username);
    }

    public boolean isHTTP() {
        return true;
    }

    public boolean isSOCKS() {
        return !this.isHTTP();
    }

    public Proxy getProxy() {
        return this.hasProxy() ? new Proxy(this.isHTTP() ? Proxy.Type.HTTP : Proxy.Type.SOCKS, new InetSocketAddress(this.host, this.port)) : Proxy.NO_PROXY;
    }

    public void encryptFields(PasswordEncryptionService cryptoService) {
        this.password = cryptoService.encryptIfNotEncryptedOrEmpty(this.password);
    }

    public void decryptFields(PasswordEncryptionService cryptoService) {
        this.password = cryptoService.decryptIfEncrypted(this.password);
    }

    public String getAsString() {
        Object proxy = "";
        if (StringUtils.isNotEmpty((String)this.host) && this.port != 0) {
            proxy = this.host + ":" + this.port;
            if (StringUtils.isNotEmpty((String)this.username)) {
                proxy = StringUtils.isNotEmpty((String)this.password) ? this.username + ":" + this.password + "@" + (String)proxy : this.username + "@" + (String)proxy;
            }
        }
        return proxy;
    }
}

