/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.rpc.LocalBackendPrivilegedIntercomAPIClient;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import com.google.gson.JsonObject;
import org.apache.commons.cli.Options;

public class AddAdminPublicAPIKeyCommand
extends CLICommandWithInvalidateCommonFilesCache {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.add-admin-api-key");

    @Override
    public String usageString() {
        return "add-admin-api-key";
    }

    @Override
    public String description() {
        return "Adds an administrator-level public API key to DSS";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, "add-admin-api-key", true);
        GHSpring.doCLISetup();
        try (RWTransaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginWriteAsDSS();){
            PublicAPIKeysService keysService = new PublicAPIKeysService();
            keysService.standalone = true;
            GlobalScopePublicAPIKey key = new GlobalScopePublicAPIKey();
            key.label = "Added by dku command-line";
            key.createdBy = "CLI";
            key.createdOn = System.currentTimeMillis();
            key.globalPermissions.withAdmin(true);
            System.out.println(keysService.createGlobalAPIKey((GlobalScopePublicAPIKey)key).key);
            t.commit("CLI: Added an admin API key");
            int n = 0;
            return n;
        }
    }

    @Override
    public void onPostExecute() {
        super.onPostExecute();
        try (LocalBackendPrivilegedIntercomAPIClient client = new LocalBackendPrivilegedIntercomAPIClient();){
            client.postObject("dip/api/pintercom/users-mappings/sync", Void.class, new JsonObject());
        }
        catch (Exception e) {
            logger.warn((Object)"User mapping sync failed, Dataiku Govern server not running? If it is running, you should restart Dataiku Govern", (Throwable)e);
        }
    }
}

