/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommand;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.core.storage.admin.IDBDumpDAO;
import com.dataiku.gh.core.storage.admin.IDBMigrationDAO;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.postgresql.util.PSQLException;

public class DumpDBCommand
extends CLICommand {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.govern-dump-db");
    public static final String COMMAND_NAME = "__dump-db";

    @Override
    public String usageString() {
        return "__dump-db TARGET_DIR INCLUDE_HISTORY";
    }

    @Override
    public String description() {
        return "Dump the database";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        options.addOption("wait", true, "If needed, wait X seconds for the DB to be up");
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        boolean includeHistory;
        String targetDir;
        block10: {
            CommandLine cmdLine = this.parseAndMiniSetup(args, COMMAND_NAME, true);
            if (cmdLine.getArgs().length < 2) {
                return this.usage(1, "Missing TARGET_DIR argument");
            }
            if (cmdLine.getArgs().length < 3) {
                return this.usage(1, "Missing INCLUDE_HISTORY argument");
            }
            targetDir = cmdLine.getArgs()[1];
            includeHistory = Integer.parseInt(cmdLine.getArgs()[2]) == 1;
            String waitStr = cmdLine.getOptionValue("wait", "0");
            int wait = 0;
            try {
                wait = Integer.parseInt(waitStr);
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to parse wait parameter", (Throwable)e);
            }
            GHSpring.doCLISetupWithDB();
            IDBMigrationDAO migrationDAO = (IDBMigrationDAO)SpringUtils.getBean(IDBMigrationDAO.class);
            try {
                migrationDAO.getSchemaVersion();
            }
            catch (Exception e) {
                boolean success = false;
                if (wait > 0 && ExceptionUtils.hasCauseOfClass((Throwable)e, PSQLException.class)) {
                    logger.warn((Object)("Failed to get the version, DB may not be up yet, retry for " + wait + " seconds. Error: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    int interval = 10;
                    for (int waited = 0; waited < wait; waited += interval) {
                        int waitThisRound = Math.min(interval, wait - waited);
                        try {
                            Thread.sleep((long)waitThisRound * 1000L);
                            migrationDAO.getSchemaVersion();
                            success = true;
                            break;
                        }
                        catch (Exception e2) {
                            logger.warn((Object)("Waited " + waitThisRound + " seconds, but still failing. Error: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
                            continue;
                        }
                    }
                }
                if (success) break block10;
                throw e;
            }
        }
        IDBDumpDAO dbDumpDAO = (IDBDumpDAO)SpringUtils.getBean(IDBDumpDAO.class);
        dbDumpDAO.dumpDB(DKUApp.getFile((String)targetDir), includeHistory);
        return 0;
    }
}

