/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.security.ConfigFileSymmetricKeyBasedPasswordEncryptionProvider;
import com.dataiku.dip.security.RegularPasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommandWithInvalidateCommonFilesCache;
import com.dataiku.gh.server.services.DKUTransactionService;
import org.apache.commons.cli.Options;

public class GenerateCryptoKeyCommand
extends CLICommandWithInvalidateCommonFilesCache {
    @Override
    public String usageString() {
        return "generate-crypto-key";
    }

    @Override
    public String description() {
        return "";
    }

    @Override
    protected boolean warnIfCacheInvalidationFails() {
        return false;
    }

    @Override
    public Options opts() {
        Options options = new Options();
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        this.parseAndMiniSetup(args, "generate-crypto-key", true);
        GHSpring.doCLISetup();
        try (DKUTransactionService ts = new DKUTransactionService();
             RWTransaction rwt = ts.beginWriteAsDSS();){
            RelFile rf = ConfigFileSymmetricKeyBasedPasswordEncryptionProvider.DEFAULT_CONFIG_KEY_FILE;
            if (rwt.exists(rf)) {
                throw new Exception("Please remove configkey.json first");
            }
            ConfigFileSymmetricKeyBasedPasswordEncryptionProvider.generateDefaultKey();
            RegularPasswordEncryptionService symetricCryptoService = (RegularPasswordEncryptionService)SpringUtils.getBean(RegularPasswordEncryptionService.class);
            symetricCryptoService.reinit();
            rwt.commit("CLI: generated crypto key");
        }
        return 0;
    }
}

