/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.controllers.admin;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.context.GovernAction;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.models.history.ActionType;
import com.dataiku.gh.core.services.custom_pages.IAdminCustomPagesService;
import com.dataiku.gh.security.auth.UIAuthService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminCustomPagesController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UIAuthService authService;
    @Autowired
    private IAdminCustomPagesService adminCustomPagesService;

    @AuditInline
    @RequestMapping(value={"/api/admin/custom-pages/create"}, method={RequestMethod.POST})
    @GovernAction(value=ActionType.CUSTOM_PAGE_CREATE)
    @ResponseBody
    public CustomPage create(HttpServletRequest req, @RequestParam CustomPage customPage, @RequestParam String newIdentifier) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            CustomPage createdCustomPage = this.adminCustomPagesService.createCustomPage(authCtx, customPage, newIdentifier);
            this.auditTrailService.generic("admin-custom-page-create").with("customPageId", createdCustomPage.id).emit();
            return createdCustomPage;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-create", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/api/admin/custom-pages/save"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.CUSTOM_PAGE_SAVE)
    @ResponseBody
    public CustomPage save(HttpServletRequest req, @RequestParam CustomPage customPage) throws Exception {
        try {
            AuthCtx authCtx;
            try (Transaction t = this.transactionService.beginRead();){
                authCtx = this.authService.getMandatoryUser(req);
            }
            CustomPage updatedCustomPage = this.adminCustomPagesService.saveCustomPage(authCtx, customPage);
            this.auditTrailService.generic("admin-custom-page-save").with("customPageId", updatedCustomPage.id).emit();
            return updatedCustomPage;
        }
        catch (Exception e) {
            this.auditTrailService.failure("admin-custom-page-save", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "admin-custom-page-delete", "customPageId", "${customPageId}"})
    @RequestMapping(value={"/api/admin/custom-pages/delete"}, method={RequestMethod.DELETE})
    @GovernAction(value=ActionType.CUSTOM_PAGE_DELETE)
    public void delete(HttpServletRequest req, HttpServletResponse resp, @RequestParam String customPageId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        this.adminCustomPagesService.deleteCustomPage(authCtx, customPageId);
        AdminCustomPagesController.writeEmptyJSONObj((HttpServletResponse)resp);
    }

    @AuditedCall(value={"msgType", "admin-custom-page-order-save"})
    @RequestMapping(value={"/api/admin/custom-pages/order"}, method={RequestMethod.PUT})
    @GovernAction(value=ActionType.CUSTOM_PAGE_ORDER_SAVE)
    @ResponseBody
    public List<String> saveOrder(HttpServletRequest req, @RequestParam List<String> customPageIds) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminCustomPagesService.saveOrder(authCtx, customPageIds);
    }

    @AuditedCall(value={"msgType", "admin-custom-page-order-get"})
    @RequestMapping(value={"/api/admin/custom-pages/order"}, method={RequestMethod.GET})
    @ResponseBody
    public List<String> getOrder(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getMandatoryUser(req);
        }
        return this.adminCustomPagesService.getOrder(authCtx);
    }
}

