/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.dss;

import com.dataiku.gh.core.models.dss.IDSSArtifactContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public abstract class AbstractDSSDeployerArtifactsContainer<APIDEPLOYERINFRA extends IDSSArtifactContainer, APIDEPLOYERDEPLOYMENT extends IDSSArtifactContainer, PROJECTDEPLOYERINFRA extends IDSSArtifactContainer, PROJECTDEPLOYERDEPLOYMENT extends IDSSArtifactContainer> {
    private final Map<String, APIDEPLOYERINFRA> apiDeployerInfras = new HashMap<String, APIDEPLOYERINFRA>();
    private final Map<String, APIDEPLOYERDEPLOYMENT> apiDeployerDeployments = new HashMap<String, APIDEPLOYERDEPLOYMENT>();
    private final Map<String, PROJECTDEPLOYERINFRA> projectDeployerInfras = new HashMap<String, PROJECTDEPLOYERINFRA>();
    private final Map<String, PROJECTDEPLOYERDEPLOYMENT> projectDeployerDeployments = new HashMap<String, PROJECTDEPLOYERDEPLOYMENT>();
    public final List<IDSSArtifactContainer> duplicatedArtifacts = new ArrayList<IDSSArtifactContainer>();

    public Map<String, APIDEPLOYERINFRA> getAPIInfras() {
        return this.apiDeployerInfras;
    }

    public Map<String, APIDEPLOYERDEPLOYMENT> getAPIDeployments() {
        return this.apiDeployerDeployments;
    }

    public Map<String, PROJECTDEPLOYERINFRA> getProjectInfras() {
        return this.projectDeployerInfras;
    }

    public Map<String, PROJECTDEPLOYERDEPLOYMENT> getProjectDeployments() {
        return this.projectDeployerDeployments;
    }

    public void addAPIInfra(APIDEPLOYERINFRA container) {
        this.checkDuplicateAndAdd(this::getAPIInfras, (IDSSArtifactContainer)container);
    }

    public void addProjectInfra(PROJECTDEPLOYERINFRA container) {
        this.checkDuplicateAndAdd(this::getProjectInfras, (IDSSArtifactContainer)container);
    }

    public void addAPIDeployment(APIDEPLOYERDEPLOYMENT container) {
        this.checkDuplicateAndAdd(this::getAPIDeployments, (IDSSArtifactContainer)container);
    }

    public void addProjectDeployment(PROJECTDEPLOYERDEPLOYMENT container) {
        this.checkDuplicateAndAdd(this::getProjectDeployments, (IDSSArtifactContainer)container);
    }

    protected final <T extends IDSSArtifactContainer> void checkDuplicateAndAdd(Supplier<Map<String, T>> getTarget, T container) {
        Map<String, T> map = getTarget.get();
        if (map.containsKey(container.getIdentifier())) {
            this.duplicatedArtifacts.add(container);
        } else {
            map.put(container.getIdentifier(), container);
        }
    }
}

