/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.plugins;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.gh.core.models.plugins.GHPluginAction;
import com.dataiku.gh.core.models.plugins.PluginDesc;
import com.dataiku.gh.core.services.plugins.IPluginsRegistryService;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class PluginsRegistryService
implements IPluginsRegistryService {
    private final Map<String, PluginDesc> map = new ConcurrentHashMap<String, PluginDesc>();

    @Override
    public void checkNotRegistered(String pluginId) {
        if (this.map.containsKey(pluginId)) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_CANNOT_LOAD, "Duplicate plugin identifier: '" + pluginId + "' is already loaded.");
        }
    }

    @Override
    public void register(String pluginId, PluginDesc pluginDesc) {
        this.map.put(pluginId, pluginDesc);
    }

    @Override
    public JsonObject runAction(AuthCtx authCtx, String pluginId, String actionId, String artifactId, JsonObject params) throws CodedException {
        PluginDesc pluginDesc = this.map.get(pluginId);
        if (pluginDesc == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_NOT_FOUND, "Cannot perform action, plugin not found: " + pluginId);
        }
        GHPluginAction action = pluginDesc.actions.get(actionId);
        if (action == null) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_ACTION_NOT_FOUND, "Action not found: " + actionId + " (" + pluginId + ")");
        }
        try {
            return action.runAction(authCtx, artifactId, params);
        }
        catch (CodedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CodedException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_ACTION_ERROR, "Error while executing action: " + actionId + " (" + pluginId + ")", (Throwable)e);
        }
    }

    @Override
    public Collection<PluginDesc> getLoadedPlugins() {
        return Lists.newArrayList(this.map.values());
    }

    @Override
    public Collection<String> getLoadedPluginIds() {
        return Lists.newArrayList(this.map.keySet());
    }
}

