/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.blueprints;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.blueprints.EnrichedBlueprintVersionRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintPermissions;
import com.dataiku.gh.core.storage.sql.model.QBlueprintRoleAssignments;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTraces;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersions;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionsHistory;
import com.dataiku.gh.core.storage.sql.model.QBlueprints;
import com.dataiku.gh.core.storage.sql.signoff.SignoffsConfigurationsDAO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BlueprintVersionDAO
extends AbstractItemBasedDAO<BlueprintVersionId, BlueprintVersion, EnrichedBlueprintVersion>
implements IBlueprintVersionDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.blueprint-versions");
    @Autowired
    private EnrichedBlueprintVersionRowMapper enrichedBlueprintVersionRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT_VERSION;
    }

    @Override
    protected RowMapper<EnrichedBlueprintVersion> getRowMapper() {
        return this.enrichedBlueprintVersionRowMapper;
    }

    @Override
    protected BlueprintVersionId getId(BlueprintVersion item) {
        return item.id;
    }

    @Override
    protected RelationalPathBase<?> getItemTablePath() {
        return QBlueprintVersions.blueprintVersions;
    }

    @Override
    protected SimplePath<Object> getItemTableJsonColumnPath() {
        return QBlueprintVersions.blueprintVersions.blueprintVersionJson;
    }

    @Override
    protected Predicate getIdCondition(BlueprintVersionId blueprintVersionId) {
        return this.equalsBlueprintVersionId(blueprintVersionId);
    }

    @Override
    protected RelationalPathBase<?> getHistoryTablePath() {
        return QBlueprintVersionsHistory.blueprintVersionsHistory;
    }

    @Override
    protected SimplePath<Object> getHistoryRevisionColumnPath() {
        return QBlueprintVersionsHistory.blueprintVersionsHistory._revisionJson;
    }

    @Override
    protected SimplePath<Object> getHistoryJsonColumnPath() {
        return QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionJson;
    }

    @Override
    protected void sqlLock(BlueprintVersionId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersions.blueprintVersions)).innerJoin((EntityPath)QBlueprints.blueprints)).on((Predicate)QBlueprints.blueprints.blueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId))).where((Predicate)this.equalsBlueprintVersionId(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    public List<EnrichedBlueprintVersion> listByBlueprint(String blueprintId) throws IOException {
        SQLQuery query = (SQLQuery)this.buildBaseSelectQuery().where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)blueprintId));
        try {
            return this.querydslJdbcTemplate.query(query, this.enrichedBlueprintVersionRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private BooleanExpression equalsBlueprintVersionId(BlueprintVersionId id) {
        if (id == null || StringUtils.isBlank((String)id.blueprintId) || StringUtils.isBlank((String)id.versionId)) {
            throw ErrorContext.iae((String)"Blueprint version ID is required");
        }
        return QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId.eq((Object)id.blueprintId).and((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId.eq((Object)id.versionId));
    }

    @Override
    protected SQLQuery<?> buildBaseSelectQuery() {
        return ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.from((Expression)QBlueprintVersions.blueprintVersions)).innerJoin((EntityPath)QBlueprints.blueprints)).on((Predicate)QBlueprints.blueprints.blueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId))).innerJoin((EntityPath)QBlueprintVersionTraces.blueprintVersionTraces)).on((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceVersionId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId)))).leftJoin((EntityPath)QBlueprintRoleAssignments.blueprintRoleAssignments)).on((Predicate)QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).leftJoin((EntityPath)QBlueprintPermissions.blueprintPermissions)).on((Predicate)QBlueprintPermissions.blueprintPermissions.blueprintPermissionsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).select(new Expression[]{QBlueprints.blueprints.blueprintJson, QBlueprintVersions.blueprintVersions.blueprintVersionJson, QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceJson, SignoffsConfigurationsDAO.buildSignoffsConfigurationsByBlueprintVersionSubQuery((Expression<String>)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId, (Expression<String>)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId), QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsJson, QBlueprintPermissions.blueprintPermissions.blueprintPermissionsJson});
    }
}

