/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.search.governance;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.services.governance.utils.GovernanceUtils;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHMandatoryTransaction;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QArtifacts;
import com.dataiku.gh.core.storage.sql.model.QArtifactsChildrenToAutogovern;
import com.dataiku.gh.core.storage.sql.model.QReferenceRelationships;
import com.dataiku.gh.core.storage.sql.search.governance.IGovernanceArtifactSearchDAO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.CaseBuilder;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class GovernanceArtifactSearchDAO
extends AbstractPostgreSQLClient
implements IGovernanceArtifactSearchDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.governance-artifact-search");

    @Override
    @GHMandatoryTransaction
    public Set<String> findChildrenArtifactIdsToRunAutoGovernanceOn(String parentArtifactId) throws IOException {
        try {
            SQLQuery query = (SQLQuery)this.sqlQueryFactory.select((Expression)QArtifactsChildrenToAutogovern.artifactsChildrenToAutogovern.artifactId).from(QArtifactsChildrenToAutogovern.asRelationalFunctionCall((Expression<String>)Expressions.constant((Object)parentArtifactId)));
            return new HashSet<String>(this.querydslJdbcTemplate.queryForList(query, String.class));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> findElementsFromArtifactToRunAutoGovernanceOn(Artifact artifact) throws IOException {
        if (!GovernanceUtils.isGoverned(artifact)) {
            return Set.of(artifact.id);
        }
        return this.findChildrenArtifactIdsToRunAutoGovernanceOn(artifact.id);
    }

    @Override
    @GHMandatoryTransaction
    public Set<String> findAllInstanceElementsToRunAutoGovernanceOn() throws IOException {
        logger.info((Object)"Fetching all governable items from instance");
        Set<String> elements = this.findAllGovernableItems();
        logger.info((Object)String.format("Found %s governable items on instance", elements.size()));
        return elements;
    }

    private Set<String> findAllGovernableItems() throws IOException {
        try {
            PathBuilder projectAlias = new PathBuilder(Tuple.class, "project");
            PathBuilder extractedAlias = new PathBuilder(String.class, "extracted_id");
            StringPath projectIdFromSubquery = Expressions.stringPath((Path)projectAlias, (String)ColumnMetadata.getName((Path)QArtifacts.artifacts.artifactId));
            String governedBy = "governed_by";
            StringPath projectGovernedBy = Expressions.stringPath((Path)projectAlias, (String)governedBy);
            StringExpression ungovernedProjectOrGovernedProjectGovernableChildren = (StringExpression)new CaseBuilder().when((Predicate)projectGovernedBy.isNull()).then((StringExpression)projectIdFromSubquery).otherwise((Expression)extractedAlias);
            StringTemplate referenceFieldId = Expressions.stringTemplate((String)"{0}->'relationshipData'->>'fieldId'", (Object[])new Object[]{QReferenceRelationships.referenceRelationships.referenceRelationshipJson});
            SQLQuery projectIdAndGovernanceStatus = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QArtifacts.artifacts.artifactId, QReferenceRelationships.referenceRelationships.referenceRelationshipArtifactIdTo.as(governedBy)}).from((Expression)QArtifacts.artifacts)).leftJoin((EntityPath)QReferenceRelationships.referenceRelationships)).on((Predicate)QReferenceRelationships.referenceRelationships.referenceRelationshipArtifactIdFrom.eq((Expression)QArtifacts.artifacts.artifactId).and((Predicate)referenceFieldId.eq((Object)"governed_by")))).where((Predicate)QArtifacts.artifacts.artifactBlueprintId.eq((Object)SystemProvidedConstants.DATAIKU_PROJECT.blueprintId));
            SQLQuery governableItemsQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.selectDistinct((Expression)ungovernedProjectOrGovernedProjectGovernableChildren).from((Expression)projectIdAndGovernanceStatus.as((Path)projectAlias))).leftJoin(QArtifactsChildrenToAutogovern.asRelationalFunctionCall((Expression<String>)projectIdFromSubquery), (Path)extractedAlias)).on((Predicate)projectGovernedBy.isNotNull())).where((Predicate)ungovernedProjectOrGovernedProjectGovernableChildren.isNotNull());
            return new HashSet<String>(this.querydslJdbcTemplate.queryForList(governableItemsQuery, String.class));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }
}

