/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.security.mappings;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.security.mappings.UserMapping;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.security.mappings.IUserMappingDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.model.QUserMappings;
import com.dataiku.gh.core.storage.sql.model.QUserMappingsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Repository;

@Repository
public class UserMappingDAO
extends AbstractPostgreSQLClient
implements IUserMappingDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.user-mapping");
    @Autowired
    protected IHistoryDataService historyDataService;

    @Override
    public List<UserMapping> listAllUserMappings() throws IOException {
        return this.listUserMappingsInternal(true, Collections.emptyList());
    }

    @Override
    public List<UserMapping> listUserMappings(Collection<String> logins) throws IOException {
        return this.listUserMappingsInternal(false, logins);
    }

    private List<UserMapping> listUserMappingsInternal(boolean listAll, Collection<String> logins) throws IOException {
        if (!listAll && CollectionUtils.isEmpty(logins)) {
            return Collections.emptyList();
        }
        SQLQuery query = (SQLQuery)this.sqlQueryFactory.select(QUserMappings.userMappings.userMappingJson).from((Expression)QUserMappings.userMappings);
        if (!listAll) {
            query = (SQLQuery)query.where((Predicate)QUserMappings.userMappings.userMappingUserLogin.in(logins));
        }
        try {
            return this.querydslJdbcTemplate.query(query, (rs, rowNum) -> (UserMapping)JSON.parse((String)rs.getString(ColumnMetadata.getName(QUserMappings.userMappings.userMappingJson)), UserMapping.class));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void createUserMappings(Collection<UserMapping> userMappings) throws IOException {
        if (CollectionUtils.isEmpty(userMappings)) {
            return;
        }
        try {
            SQLInsertClause insert = this.sqlQueryFactory.insert((RelationalPath)QUserMappings.userMappings);
            for (UserMapping userMapping : userMappings) {
                ((SQLInsertClause)insert.set(QUserMappings.userMappings.userMappingJson, QueryBuilderUtils.toJsonb(userMapping))).addBatch();
            }
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insert);
            this.insertHistoryRevisions(RevisionType.ADD, userMappings);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void deleteUserMappings(Collection<UserMapping> userMappings) throws IOException {
        if (CollectionUtils.isEmpty(userMappings)) {
            return;
        }
        try {
            this.insertHistoryRevisions(RevisionType.DELETE, userMappings);
            SQLDeleteClause delete = this.sqlQueryFactory.delete((RelationalPath)QUserMappings.userMappings);
            for (UserMapping userMapping : userMappings) {
                ((SQLDeleteClause)delete.where((Predicate)QUserMappings.userMappings.userMappingArtifactId.eq((Object)userMapping.artifactId).and((Predicate)QUserMappings.userMappings.userMappingUserLogin.eq((Object)userMapping.userLogin)))).addBatch();
            }
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)delete);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void insertHistoryRevisions(RevisionType revisionType, Collection<UserMapping> userMappings) throws IOException {
        SQLInsertClause insertHistory = this.sqlQueryFactory.insert((RelationalPath)QUserMappingsHistory.userMappingsHistory);
        for (UserMapping userMapping : userMappings) {
            HistoryRevision historyRevision = this.historyDataService.createRevision(revisionType, EntityType.USER_MAPPING);
            ((SQLInsertClause)((SQLInsertClause)insertHistory.set(QUserMappingsHistory.userMappingsHistory._revisionJson, QueryBuilderUtils.toJsonb(historyRevision))).set(QUserMappingsHistory.userMappingsHistory.userMappingJson, QueryBuilderUtils.toJsonb(userMapping))).addBatch();
        }
        this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insertHistory);
    }
}

