/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.controllers.admin;

import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUProfiler;
import com.dataiku.gh.dao.ProfilingDAO;
import com.dataiku.gh.security.auth.UIAuthService;
import com.dataiku.gh.server.services.BackendProfilingService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminProfilingController
extends DIPInternalControllerBase {
    @Autowired
    BackendProfilingService backendProfilingService;
    @Autowired
    TransactionService transactionService;
    @Autowired
    UIAuthService authService;

    @AuditedCall(value={"msgType", "performance-profiles-list"})
    @RequestMapping(value={"/api/admin/profiling/list"}, method={RequestMethod.GET})
    @ResponseBody
    public List<DKUProfiler.PerformanceProfile> listProfiles(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            List list = this.backendProfilingService.listProfiles();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "performance-profiles-get", "id", "${id}"})
    @RequestMapping(value={"/api/admin/profiling/get"}, method={RequestMethod.GET})
    public void getProfile(HttpServletRequest req, HttpServletResponse resp, @RequestParam String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdminNoXSRF(req);
        }
        this.writeFileForDownload(resp, this.backendProfilingService.getProfileFile(id), "application/octet-stream", id);
    }

    @AuditedCall(value={"msgType", "performance-profiles-delete", "id", "${id}"})
    @RequestMapping(value={"/api/admin/profiling/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleteProfile(HttpServletRequest req, String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
        }
        this.backendProfilingService.deleteProfile(id);
        return null;
    }

    @AuditedCall(value={"msgType", "performance-profiles-config-get"})
    @RequestMapping(value={"/api/admin/profiling/get-config"}, method={RequestMethod.GET})
    @ResponseBody
    public ProfilingDAO.ProfilerSettings getConfig(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.failIfNotAdmin(req);
            ProfilingDAO.ProfilerSettings profilerSettings = (ProfilingDAO.ProfilerSettings)this.backendProfilingService.getConfig();
            return profilerSettings;
        }
    }

    @AuditedCall(value={"msgType", "performance-profiles-config-save"})
    @RequestMapping(value={"/api/admin/profiling/save-config"}, method={RequestMethod.POST})
    @ResponseBody
    public Object saveConfig(HttpServletRequest req, @RequestParam ProfilingDAO.ProfilerSettings config) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForUI(req);){
            this.authService.failIfNotAdmin(req);
            this.backendProfilingService.saveConfig(config);
            t.commit("Saved profiler settings");
        }
        return null;
    }
}

