/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services;

import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.NoRemoteFutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.SmartLogTail;
import com.dataiku.dss.shadelib.org.apache.commons.io.comparator.LastModifiedFileComparator;
import com.dataiku.dss.shadelib.org.apache.commons.io.filefilter.WildcardFileFilter;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.futures.SimpleFutureThread;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.collect.Lists;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DiagnosticsService {
    @Autowired
    NoRemoteFutureService futureService;
    static DKULogger logger = DKULogger.getLogger((String)"dku.diagnostics");

    public FutureResponse<DiagnosticResult> run(String serializedOptions, AuthCtx user) throws Exception {
        DiagnosticsOptions opts = null;
        if (StringUtils.isNotBlank((String)serializedOptions)) {
            opts = (DiagnosticsOptions)JSON.parse((String)serializedOptions, DiagnosticsOptions.class);
        }
        return this.futureService.runFuture((FutureThreadBase)new DiagnosticsFutureThread(opts, (GHAuthCtx)user), 0L, (TypeToken)new TypeToken<FutureResponse<DiagnosticResult>>(){});
    }

    public File getLatestDiagnosisFile() throws IOException {
        WildcardFileFilter filter = new WildcardFileFilter("dku_diagnosis*.zip");
        File[] logFiles = ApplicationConfigurator.getFile((String)"diagnosis").listFiles((FileFilter)filter);
        if (logFiles != null && logFiles.length > 0) {
            Arrays.sort(logFiles, LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            return logFiles[0];
        }
        return null;
    }

    @UIModel
    class DiagnosticsOptions {
        boolean includeConfigDir;
        boolean includeBackendStacks;
        boolean includeFullLogs;
        boolean includeFullDataDirListing;
        boolean includeDBDump;
        boolean includeHistoryDBDump;

        DiagnosticsOptions() {
        }
    }

    class DiagnosticsFutureThread
    extends SimpleFutureThread<DiagnosticResult> {
        private final DiagnosticsOptions opts;
        private DKUtils.SmartLogTailBuilder logTailBuilder;

        public DiagnosticsFutureThread(DiagnosticsOptions opts, GHAuthCtx authCtx) {
            super((AuthCtx)authCtx);
            this.logTailBuilder = new DKUtils.SmartLogTailBuilder();
            this.opts = opts;
        }

        public FuturePayload getPayload() {
            return FuturePayload.newSimple((String)"diagnostics", (String)"Running diagnostics");
        }

        @Override
        public DiagnosticResult compute() throws Exception {
            String binary = System.getenv("DIP_HOME") + "/bin/govern-admin";
            ArrayList cmd = Lists.newArrayList((Object[])new String[]{binary});
            cmd.add("run-diagnosis");
            if (this.opts != null) {
                if (this.opts.includeConfigDir) {
                    cmd.add("-c");
                }
                if (this.opts.includeBackendStacks) {
                    cmd.add("-s");
                }
                if (this.opts.includeFullLogs) {
                    cmd.add("-f");
                }
                if (this.opts.includeFullDataDirListing) {
                    cmd.add("-l");
                }
                if (this.opts.includeDBDump) {
                    cmd.add("-d");
                }
                if (this.opts.includeHistoryDBDump) {
                    cmd.add("-e");
                }
            }
            HashMap<String, String> env = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)System.getenv("DSS_DEV"))) {
                env.put("DEV_MODE", "1");
            }
            cmd.add(System.getenv("DIP_HOME") + "/diagnosis/dku_diagnosis_" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + ".zip");
            logger.info((Object)("Launching diagnostic tool:  " + StringUtils.join((Collection)cmd, (String)" ")));
            DKUtils.execAndLogThrows((String[])cmd.toArray(new String[0]), env, (DKUtils.SmartLogTailBuilder)this.logTailBuilder);
            return new DiagnosticResult();
        }

        public SmartLogTail getLog() {
            return this.logTailBuilder.get();
        }
    }

    static class DiagnosticResult {
        DiagnosticResult() {
        }
    }
}

