/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.agents.tools.vectorstore;

import com.dataiku.dip.agents.tools.AgentTool;
import com.dataiku.dip.agents.tools.AgentToolMeta;
import com.dataiku.dip.agents.tools.AgentToolParams;
import com.dataiku.dip.agents.tools.AgentToolRunner;
import com.dataiku.dip.agents.tools.utils.JsonSchema;
import com.dataiku.dip.agents.tools.vectorstore.VectorStoreQueryToolRunner;
import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.llm.retrieval.BaseVectorStoreQuerySettings;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledge;
import com.dataiku.dip.llm.retrieval.RetrievableKnowledgeDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.Params;
import com.dataiku.j2py.annotations.PyModel;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class VectorStoreQueryTool {
    public static final AgentToolMeta META = new AgentToolMeta(false){

        @Override
        public String getType() {
            return "VectorStoreSearch";
        }

        @Override
        public Class<? extends AgentToolParams> paramsClass() {
            return VectorStoreQueryToolParams.class;
        }

        @Override
        public List<SavedModel.AgentDependency> getDependencies(AgentTool tool) {
            VectorStoreQueryToolParams p = tool.getParamsCopyAs(VectorStoreQueryToolParams.class);
            if (StringUtils.isNotBlank((String)p.knowledgeBankRef)) {
                return Lists.newArrayList((Object[])new SavedModel.AgentDependency[]{new SavedModel.AgentDependency(ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE, p.knowledgeBankRef)});
            }
            return new ArrayList<SavedModel.AgentDependency>();
        }

        @Override
        public AgentToolMeta.ToolDescriptor getResultingDescriptor(AuthCtx authCtx, String projectKey, AgentTool tool) throws IOException {
            TransactionContext.assertNoAttachedTransaction();
            VectorStoreQueryToolParams p = tool.getParamsCopyAs(VectorStoreQueryToolParams.class);
            AgentToolMeta.ToolDescriptor td = new AgentToolMeta.ToolDescriptor(tool.name);
            td.description = "Searches for relevant documents in the knowledge bank (vector store)";
            if (p.knowledgeBankRef == null) {
                td.description = td.description + " (error: no knowledge bank selected).";
                return td;
            }
            RetrievableKnowledgeDAO rkDAO = (RetrievableKnowledgeDAO)SpringUtils.getBean(RetrievableKnowledgeDAO.class);
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            RetrievableKnowledge kb = null;
            try (Transaction t = transactionService.beginRead();){
                kb = (RetrievableKnowledge)rkDAO.getMandatory(AnyLoc.resolveSmart(projectKey, p.knowledgeBankRef));
            }
            td.description = td.description + " " + kb.name;
            if (StringUtils.isNotBlank((String)tool.additionalDescriptionForLLM)) {
                td.description = td.description + "\n\n" + tool.additionalDescriptionForLLM;
            }
            td.inputSchema = JsonSchema.newObject("https://dataiku.com/agents/tools/knowledge-banks/lookup/input", "Search settings for a knowledge bank");
            td.inputSchema.properties.put("searchQuery", JsonSchema.string("The search query in the knowledge bank / vector store"));
            return td;
        }

        @Override
        public AgentToolRunner buildRunner(AuthCtx authCtx, String projectKey, AgentTool tool, boolean devKernel) throws IOException {
            VectorStoreQueryToolParams p = tool.getParamsCopyAs(VectorStoreQueryToolParams.class);
            RetrievableKnowledgeDAO rkDAO = (RetrievableKnowledgeDAO)SpringUtils.getBean(RetrievableKnowledgeDAO.class);
            TransactionService transactionService = (TransactionService)SpringUtils.getBean(TransactionService.class);
            RetrievableKnowledge kb = null;
            try (Transaction t = transactionService.beginRead();){
                kb = (RetrievableKnowledge)rkDAO.getMandatory(AnyLoc.resolveSmart(projectKey, p.knowledgeBankRef));
            }
            Params dkuParams = AbstractSQLConnection.CustomDatabaseProperty.toParams(tool.dkuProperties);
            boolean devMode = dkuParams.getBoolParam("dku.agents.tool.python.devMode", false);
            return new VectorStoreQueryToolRunner((DSSAuthCtx)authCtx, projectKey, kb, tool, devKernel, devMode);
        }
    };
    private static DKULogger logger = DKULogger.getLogger((String)"dku.agents.tools.vectorstore");

    @PyModel
    public static class VectorStoreQueryToolParams
    extends BaseVectorStoreQuerySettings
    implements AgentToolParams {
        public String knowledgeBankRef;
        public boolean includeMultimodalContent;
    }
}

